#ifndef PIXMAP_H
#define PIXMAP_H

#include <QPixmap>
#include <QSvgRenderer>
#include <QStringList>

class Pixmap: public QPixmap {
 public:
  enum State { Normal, Highlight, Greyscale };
  
  Pixmap(QSvgRenderer *, const QStringList &, int = 0);
  Pixmap(const QStringList &, int = 0, State = Normal);
  ~Pixmap();
  bool is(const QString &, State);
  QPoint offset();
  static QSize prepare(QSvgRenderer *, const QString &, int);

 private:
  static bool load(QSvgRenderer *, const QString &);

  QString m_name;
  State m_state;
  QPoint m_offset;
};

#endif // PIXMAP_H
