#ifndef CUSTOMWINDOW_H
#define CUSTOMWINDOW_H

#include <QMainWindow>
#include <QKeyEvent>
#include <QPaintEvent>
#include <QString>
#include <QLabel>
#include <QVBoxLayout>

#include "iconloader.h"

#ifdef Q_OS_SYMBIAN
#include <remconcoreapitargetobserver.h>    // link against RemConCoreApi.lib
#include <remconcoreapitarget.h>            // and
#include <remconinterfaceselector.h>        // RemConInterfaceBase.lib
#endif

class CustomWindow : public QMainWindow
#ifdef Q_OS_SYMBIAN
, public MRemConCoreApiTargetObserver 
#endif
{
  Q_OBJECT;

 public:
  CustomWindow(const QString &, QWidget * = 0);
  ~CustomWindow();
  void setCentralWidget(QWidget *);
  void setWindowTitle(const QString &);
  void addMenuEntry(const QString &, QObject *, const char *);

#ifdef Q_OS_SYMBIAN
  virtual void MrccatoCommand(TRemConCoreApiOperationId aOperationId,
			      TRemConCoreApiButtonAction aButtonAct);
#endif
  void grabSpecialKeys(bool);
  
 protected:
  void keyPressEvent(QKeyEvent*);

 signals:
  void zoomInPressed();
  void zoomOutPressed();

 public slots:
  void toggleFullscreen();
#ifdef Q_OS_SYMBIAN
  void show();
#endif

 private:
  QString m_name;

  // stuff only used when doing "custom window decorations"
  IconLoader *m_iconLoader;
  QVBoxLayout *m_layout;
  QLabel *m_title;

#ifdef Q_OS_SYMBIAN
  CRemConInterfaceSelector* iInterfaceSelector;
  CRemConCoreApiTarget*     iCoreTarget;
#endif
};

#endif // CUSTOMWINDOW
