#ifndef GCBROWSER_H
#define GCBROWSER_H

#include <QObject>
#include <QNetworkReply>

#include "cache.h"
#include "cacheproviderplugin.h"

class GcBrowser : public QObject, public CacheProviderPlugin {
 Q_OBJECT
 Q_INTERFACES(CacheProviderPlugin)
    
 enum CurrentRequest { None, Overview, Info, Detail };

public:
  GcBrowser();
  ~GcBrowser();

  QString name();
  QString license();
  bool canBeDefault();
  QObject *object();

  void init(QWidget * = 0);
  void createConfig(QDialog *, QVBoxLayout*);

  bool busy();
  void processRequestOverview(const QGeoBoundingBox &);
  void processRequestInfo(const QString &);
  void processRequestDetail(const QString &);

 private slots:
  void replyFinished(QNetworkReply*);
  void applyChanges();

 signals:
  void replyOverview(const CacheList &);
  void replyInfo(const Cache &);
  void replyDetail(const Cache &);
  void replyError(const QString &);    // any request can emit a error
  void reload();
  void notifyBusy(bool);
  void done();
  void next();

 private:
  void login(const QString &, const QString &);

  enum State { SentLoginGET, SentLoginPOST, RequestedUserToken, Idle };

  void requestUserToken();
  QString subString(const QString &, const QString &, const QString &);
  bool decodeUserToken(const QString&);
  void postJson(const QString &);
  void prepareLogin();
  void doLogin();
  void handleViewStateField(const QString&);
  bool loginIsValid();
  void error(const QString &);
  int getCacheId(const QString &);
  QString getCacheGuid(const QString &);

  QNetworkAccessManager *m_manager;
  QString m_userToken;
  bool m_initialized;
  bool m_bigArea;
  CacheList m_cacheList;
  Cache m_cache;
  QString m_lastViewState;
  State m_state;

  QString m_name, m_password;
  CurrentRequest m_currentRequest;
};

#endif // GCBROWSER_H
