#ifndef HTMLVIEW_H
#define HTMLVIEW_H

#include <QTextBrowser>
#include <QNetworkReply>
#include <QMap>

#include "cache.h"

class HtmlView : public QTextBrowser {
  Q_OBJECT;

 public:
  HtmlView(const Description &, QWidget * = 0);

 public slots:
  void replyFinished(QNetworkReply*);

 private:
  QVariant loadResource(int, const QUrl &);
  QNetworkAccessManager *m_manager;

  QMap<QUrl, QPixmap> m_images;
};

#endif // HTMLVIEW_H
