#ifndef CACHE_H
#define CACHE_H

#include <QLandmark>
#include <QDate>

QTM_USE_NAMESPACE

class Description {
 public:
  Description();
  friend QDebug operator<<(QDebug, const Description &);
  void set(bool, const QString &);
  QString text() const;
  bool isHtml() const;
  bool isSet() const;

 private:
  QString m_text;
  bool m_isHtml;
};

class Tribool {
 public:
  Tribool();
  friend QDebug operator<<(QDebug, const Tribool &);
  void set(bool);
  bool value() const;
  bool isSet() const;

 private:
  bool m_value;
  bool m_set;
};

class Rating {
 public:
  Rating();
  friend QDebug operator<<(QDebug, const Rating &);
  void set(qreal);
  qreal value() const;
  QString toString() const;
  bool isSet() const;
  
 private:
  int m_value;
};

class Container {
 public:
  enum Type {
    ContainerUnknown, ContainerRegular, ContainerSmall, ContainerMicro,
    ContainerOther,   ContainerNotChosen, ContainerLarge, ContainerVirtual
  };
  
  Container();
  friend QDebug operator<<(QDebug, const Container &);
  void set(Type);
  Type get() const;
  QString toString() const;
  bool isSet() const;
  QString iconFile() const;
 
 private:
  Type m_value;
};

class Cache : public QLandmark {
 public:

  enum Type {
    TypeUnknown, TypeTraditional, TypeMulti, TypeMystery, TypeVirtual,
    TypeWebcam, TypeEvent, TypeLetterbox, TypeEarthcache, TypeWherigo,
    TypeMegaEvent, TypeCito };
  
  Cache();
  ~Cache();
  friend QDebug operator<<(QDebug, const Cache &);

  // functions dealing with generic flags
  void setOwned(bool);
  Tribool owned() const;

  void setFound(bool);
  Tribool found() const;

  void setAvailable(bool);
  Tribool available() const;

  // function dealing with owner
  void setOwner(const QString &);
  QString owner() const;

  // functions dealing with the cache type
  void setType(Type);
  Type type() const;
  QString typeString() const;
  QString typeIconFile() const;
  QString overlayIconFile() const;

  // functions dealing with the geocaching.com id
  void setId(int);
  int id() const;

  // functions dealing with the caches uuid
  void setGuid(const QString &);
  QString guid() const;

  // functions dealing with difficulty and terrain ratings
  void setDifficulty(qreal);
  Rating difficulty() const;

  void setTerrain(qreal);
  Rating terrain() const;

  // functions dealing with the container
  void setContainer(Container::Type);
  Container container() const;

  // functions dealing with date of placement
  void setDateOfPlacement(const QDate &);
  QDate dateOfPlacement() const;
  QString dateOfPlacementString() const;

  // functions dealing with descriptions
  void setShortDescription(const Description &);
  Description shortDescription() const;

  void setLongDescription(const Description &);
  Description longDescription() const;

  // functions dealing with the hint
  void setHint(const Description &);
  Description hint() const;
 
 private:
  Tribool m_owned, m_found, m_available;
  Type m_type;
  Rating m_terrain, m_difficulty;
  int m_id;
  Container m_container;
  QString m_owner;
  QDate m_dateOfPlacement;
  QString m_guid;
  Description m_shortDescription, m_longDescription;
  Description m_hint;
};

class CacheList : QList<Cache> {
 public:
  CacheList(const QString &);
  ~CacheList();
  void append(Cache);
  int size() const;
  Cache at(int);
  QString name();
  QList<Cache>::const_iterator begin() const;
  QList<Cache>::const_iterator end() const;
  void clear();

 private:
  QString m_name;
};

#endif // CACHE_H
