#ifndef MAPPAGE_H
#define MAPPAGE_H

#include <MApplicationPage>
#include <QGeoServiceProvider>

#include "mapwidget.h"
#include "cache.h"
#include "gcprovider.h"

class MapPage : public MApplicationPage {
  Q_OBJECT;

 public:
  MapPage(QGraphicsItem *parent = 0);
  ~MapPage();
  virtual void createContent();

 public slots:
  // called from map widget whenever the viewport changed
  void reloadCaches();
  // called from cacheprovider
  void updateCaches(const CacheList &);
  void displayError(const QString &);
  // called from map whenever the user clicked a cache icon
  void selectCache(const QString &);

 private:
  QGeoServiceProvider *m_serviceProvider;
  MapWidget *m_mapWidget;
  GcProvider m_cacheProvider;
  QString m_message;   
};

#endif
