// Filename: mappage.cpp

#include <QDebug>
#include <MBanner>

#include "mappage.h"
#include "mapwidget.h"

MapPage::MapPage(QGraphicsItem *parent) : MApplicationPage(parent) {

  qDebug() << __FUNCTION__ << "Cache provider " << m_cacheProvider.name();

  // setup page itself
  setTitle("CacheMe");
  this->m_serviceProvider = new QGeoServiceProvider("nokia");
  this->m_mapWidget = new MapWidget(this->m_serviceProvider->mappingManager());

  // make sure cache updates are processed
  QObject::connect(&this->m_cacheProvider, SIGNAL(replyOverview(const CacheList &)), 
		   this, SLOT(updateCaches(const CacheList &)));

  QObject::connect(&this->m_cacheProvider, SIGNAL(replyInfo(const Cache &)), 
		   this->m_mapWidget, SLOT(showBubble(const Cache &)));

  QObject::connect(&this->m_cacheProvider, SIGNAL(replyError(const QString &)), 
		   this, SLOT(displayError(const QString &)));

  QObject::connect(this->m_mapWidget, SIGNAL(mapChanged()),
		   this, SLOT(reloadCaches()));

  // connect to map to handle clicks on cache icons
  QObject::connect(this->m_mapWidget, SIGNAL(cacheClicked(const QString &)),
		   this, SLOT(selectCache(const QString &)));
}

MapPage::~MapPage() {
  qDebug() << __FUNCTION__;
  delete m_serviceProvider;
}

void MapPage::selectCache(const QString &name) {
  qDebug() << __FUNCTION__ << name;

  // ask CacheProvider for details about this cache
  this->m_cacheProvider.requestInfo(name);
}

void MapPage::reloadCaches() {
  // request new caches for the maps new viewport
  m_cacheProvider.requestOverview(this->m_mapWidget->viewport());
  //  m_cacheProvider.requestInfo("GC2GX80");
}

void MapPage::createContent() {
  setPannable(false);
  setCentralWidget(this->m_mapWidget);
}

void MapPage::updateCaches(const CacheList &cacheList) {
  m_message = "";
  this->m_mapWidget->updateCaches(cacheList);
}

void MapPage::displayError(const QString &message) {
  if(m_message != message) {
    MBanner *banner = new MBanner();
    banner->setStyleName("InformationBanner");
    banner->setTitle(message);
    banner->appear(scene(), MSceneWindow::DestroyWhenDone);

    m_message = message;
  }
}
