#include <QDebug>

#include "mapbuttonmanager.h"

MapButtonManager::MapButtonManager(int size) : QList<MapButton*>() {
  this->m_size = size;
  this->m_iconLoader = new IconLoader(size);
}

MapButtonManager::~MapButtonManager() {
  
  // destroy all Buttons inside
  QList<MapButton *>::const_iterator i;
  for( i = begin(); i != end(); ++i )
    delete *i;
  
  delete m_iconLoader;
}

MapButton* MapButtonManager::create(const QString &name, int x, int y, MapButton::State state) {
  MapButton *but = new MapButton(m_iconLoader, name, x, y, m_size, state);
  append(but);
  return but;
}

void MapButtonManager::setState(const QString &name, MapButton::State state) {
  QList<MapButton *>::const_iterator i;
  for( i = begin(); i != end(); ++i )
    if((*i)->name() == name)
      (*i)->setState(state);
}

void MapButtonManager::change(const QString &name, const QString &newIcon) {
  QList<MapButton *>::const_iterator i;
  for( i = begin(); i != end(); ++i )
    if((*i)->name() == name)
      (*i)->change(m_iconLoader, newIcon);
}


void MapButtonManager::paint(QPainter *painter) {
  QList<MapButton *>::const_iterator i;
  for( i = begin(); i != end(); ++i )
    (*i)->paint(painter);
}

bool MapButtonManager::mousePress(const QPointF &p) {
  bool change = false;

  // check if the mouse press event occured over one of the buttons  
  QList<MapButton *>::const_iterator i;
  for( i = begin(); i != end(); ++i ) 
    change |= (*i)->mousePress(p);

  return change;
}

bool MapButtonManager::mouseMove(const QPointF &p) {
  bool change = false;

  QList<MapButton *>::const_iterator i;
  for( i = begin(); i != end(); ++i ) 
    change |= (*i)->mouseMove(p);

  return change;
}

bool MapButtonManager::mouseRelease(const QPointF &p) {
  bool change = false;

  QList<MapButton *>::const_iterator i;
  for( i = begin(); i != end(); ++i ) 
    change |= (*i)->mouseRelease(p);

  return change;
}

bool MapButtonManager::isInside(const QPointF &p) const {
  bool inside = false;

  QList<MapButton *>::const_iterator i;
  for( i = begin(); i != end(); ++i ) 
    inside |= (*i)->isInside(p);

  return inside;
}
