#ifndef MAP_BUTTON_H
#define MAP_BUTTON_H

#include <QPixmap>
#include <QPointF>
#include <QPainter>

#include "iconloader.h"

class MapButton : public QObject {
  Q_OBJECT

 public:
  enum State { Normal, Selected, Disabled };
  MapButton(IconLoader *, const QString &, int, int, int, State);
  ~MapButton();
  void paint(QPainter *);
  QString name() const;
  bool setState(const State &);
  void change(IconLoader *, const QString &);
  void releaseImages();

  bool isInside(const QPointF &) const;
  bool mousePress(const QPointF &);
  bool mouseMove(const QPointF &);
  bool mouseRelease(const QPointF &);

 signals:
  void clicked();

 private:
  void renderNormal();
  void renderDisabled();
  void renderSelected();

  State m_state;
  QPixmap *m_pixmap;
  QPixmap *m_pixNormal, *m_pixDisabled, *m_pixSelected;
  QPoint m_p;
  int m_size;
  QString m_name;

  bool m_downOn;
};

#endif // MAP_BUTTON_H
