#ifndef MAPBUBBLE_H
#define MAPBUBBLE_H

#include <QGraphicsGeoMap>
#include <QGeoMapPixmapObject>

#include "iconloader.h"
#include "cache.h"

QTM_USE_NAMESPACE

class MapBubble : public QGeoMapPixmapObject {
  Q_OBJECT;

 public:
  MapBubble(const QGraphicsGeoMap *, const Cache &);
  Cache cache() const;

 private:
  qreal calculateTipOffset(const QGraphicsGeoMap *, const QGeoCoordinate &, const QSize &);
  static const int RADIUS=20;
  Cache m_cache;
};

#endif // MAPBUBBLE_H
