#ifndef CACHEPROVIDER_H
#define CACHEPROVIDER_H

#include "cache.h"

#include <QQueue>

class CacheProvider  : public QObject {
  Q_OBJECT;

 public:
  CacheProvider();
  ~CacheProvider();
  void requestOverview(const QGeoBoundingBox &);
  void requestInfo(const QString &);
  virtual void requestDetail(const QString &) = 0;

 protected:
  virtual QString name() = 0;
  virtual bool initialized() = 0;
  virtual void processRequestOverview(const QGeoBoundingBox &) = 0;
  virtual void processRequestInfo(const QString &) = 0;

 public slots:

 signals:
  void replyOverview(const CacheList &);
  void replyInfo(const Cache &);
  void replyError(const QString &);    // any request can emit a error

 private:

 protected:
  // a request entry is being kept in the request queue
  class RequestEntry {    
    
  public:
    enum RequestType { Overview, Info, Detail };
    RequestEntry(const RequestType &, const QString &);
    RequestEntry(const RequestType &, const QGeoBoundingBox &);
    RequestType type();
    QGeoBoundingBox bbox();
    QString cache();
    
  private:
    RequestType m_type;
    QGeoBoundingBox m_bbox;
    QString m_cache;
  };
  
  class RequestQueue : public QQueue<RequestEntry *> {
  private:
    CacheProvider *m_cacheProvider;

  public:
    RequestQueue(CacheProvider *);
    void add(const RequestEntry::RequestType &, const QString &);
    void add(const RequestEntry::RequestType &, const QGeoBoundingBox &);
    RequestEntry::RequestType type();
    void done();
    void next();
    void restart();
  };
  
  RequestQueue *m_pending;
};

#endif // CACHEPROVIDER_H
