#ifndef CACHE_H
#define CACHE_H

#include <QLandmark>
#include <QDate>

using namespace QtMobility;

class Tribool {
 public:
  Tribool();
  friend QDebug operator<<(QDebug, Tribool &);
  void set(bool);
  bool get() const;
  bool isSet() const;

 private:
  bool m_value;
  bool m_set;
};

class Rating {
 public:
  Rating();
  friend QDebug operator<<(QDebug, Rating &);
  void set(qreal);
  qreal get() const;
  QString toString() const;
  bool isSet() const;
  
 private:
  int m_value;
};

class Container {
 public:
  enum Type {
    ContainerUnknown, ContainerRegular, ContainerSmall, ContainerMicro,
    ContainerOther,   ContainerNotChosen, ContainerLarge, ContainerVirtual
  };
  
  Container();
  friend QDebug operator<<(QDebug, Container &);
  void set(Type);
  Type get() const;
  QString toString() const;
  bool isSet() const;
  QString iconFile() const;
 
 private:
  Type m_value;
};

class Cache : public QLandmark {
 public:

  enum Type {
    TypeUnknown, TypeTraditional, TypeMulti, TypeMystery, TypeVirtual,
    TypeWebcam, TypeEvent, TypeLetterbox, TypeEarthcache, TypeWherigo,
    TypeMegaEvent, TypeCito };
  
  Cache();
  ~Cache();
  friend QDebug operator<<(QDebug, Cache &);

  // functions dealing with generic flags
  void setOwned(bool);
  bool owned() const;

  void setFound(bool);
  bool found() const;

  void setAvailable(bool);
  bool available() const;

  // function dealing with owner
  void setOwner(const QString &);
  QString owner() const;
  bool ownerIsSet() const;

  // functions dealing with the cache type
  void setType(Type);
  Type type() const;
  QString typeString() const;
  QString typeIconFile() const;
  QString overlayIconFile() const;

  // functions dealing with the geocaching.com id
  void setId(int);
  int id() const;

  // functions dealing with difficulty and terrain ratings
  void setDifficulty(qreal);
  qreal difficulty() const;
  bool difficultyIsSet() const;

  void setTerrain(qreal);
  qreal terrain() const;
  bool terrainIsSet() const;

  // functions dealing with the container
  void setContainer(Container::Type);
  Container container() const;
  bool containerIsSet() const;

  // functions dealing with date of placement
  void setDateOfPlacement(const QDate &);
  QDate dateOfPlacement() const;
  bool dateOfPlacementIsSet() const;
  QString dateOfPlacementString() const;

 private:
  Tribool m_owned, m_found, m_available;
  Type m_type;
  Rating m_terrain, m_difficulty;
  int m_id;
  Container m_container;
  QString m_owner;
  QDate m_dateOfPlacement;
};

class CacheList : QList<Cache> {
 public:
  CacheList(const QString &);
  ~CacheList();
  void append(Cache);
  int size() const;
  Cache at(int);
  QString name();
  QList<Cache>::const_iterator begin() const;
  QList<Cache>::const_iterator end() const;
  void clear();

 private:
  QString m_name;
};

#endif // CACHE_H
