#!/usr/bin/python2.5

# A daemon that watches for bluetooth keyboard and mouse 
# connection events and performs the appropriate actions when
# the devices connect.

# Assumptions:
#   1. There's a config file (written by bt-hid-connect script)
#      with a list of configured mouse/keyboard devices.
#   2. Your keyboard or mouse has the word 'keyboard' or 'mouse'
#      in its name. This might be a problem for keyboards with
#      built-in pointer devices.

# By Alan Bruce (qole)
# Based very heavily on jakoleh's keyboard script on t.m.o

import sys
import os
# import python dbus module
import dbus
# import python dbus GLib mainloop support
import dbus.mainloop.glib
import gobject
import thread, time
import re
import commands
CONFIGFILE = "/home/user/.bt-hid-devices"

def connected(*args, **kwargs):    
    bus = dbus.SystemBus()
    iface = dbus.Interface(bus.get_object('org.freedesktop.Notifications',
                                     '/org/freedesktop/Notifications'),
                                     'org.freedesktop.Notifications')
    deviceID = ''
    deviceName = ''
    devicelist = open(CONFIGFILE)
    for device in devicelist:
        dbusDeviceID = device.rstrip('\n')
        if dbusDeviceID in kwargs:
           deviceID = dbusDeviceID.replace('dev_','')
           deviceID = deviceID.replace('_',':')

    devicelist.close()
    if len(deviceID) > 0 :
       dirs = os.listdir('/var/lib/bluetooth')
       for dir in dirs:
          if ':' in dir:
            ifacedirs = os.listdir('/var/lib/bluetooth/'+dir)
            if 'names' in ifacedirs:
               devicenames = open('/var/lib/bluetooth/'+dir+'/names')
               for nameline in devicenames:
                 if deviceID in nameline:
                    deviceName = nameline.replace(deviceID,'')
                    deviceName = deviceName.lstrip()
               devicenames.close()

    isMouse = 'mouse' in deviceName.lower()
    isKeyboard = 'keyboard' in deviceName.lower()

    if args[0] == "Connected":
        if args[1] == False:       
            iface.SystemNoteInfoprint(deviceName+" disconnected")
            if isMouse:
               print "Mouse disconnect detected!"
               mOut = commands.getoutput("/usr/bin/hidemouse")

        else:
            iface.SystemNoteInfoprint(deviceName+" connected")
            if isMouse:
               print "Mouse connect detected!"
               mOut = commands.getoutput("/usr/bin/showmouse")

            if isKeyboard:
               print "Keyboard connect detected!"
               mOut = commands.getoutput("/usr/bin/bt-kbd-remap")
    
def main():            
    dbus.mainloop.glib.DBusGMainLoop(set_as_default=True)

    # Get the session bus
    bus = dbus.SystemBus()   

    iface = dbus.Interface(bus.get_object('org.freedesktop.Notifications',
                                     '/org/freedesktop/Notifications'),
                                     'org.freedesktop.Notifications')
     
    try:       
        #Get default adapter
        manager = dbus.Interface(bus.get_object("org.bluez",
                        "/"),
                        "org.bluez.Manager")
        adapter = manager.DefaultAdapter()

    # Get the remote interface for the remote object

        devicelist = open(CONFIGFILE)
        for device in devicelist:
            DEVICE = device.rstrip('\n')
            interface = dbus.Interface(bus.get_object('org.bluez',
                                       adapter + "/" + DEVICE), 
                                       "org.bluez.Input")  

            interface.connect_to_signal("PropertyChanged", connected, sender_keyword=DEVICE)

            print "Watching "+DEVICE

        devicelist.close()

    except dbus.DBusException:        
        sys.exit(1)    

    iface.SystemNoteInfoprint("BT HID Watcher started")
    loop = gobject.MainLoop()    
    loop.run()
    
if __name__ == "__main__":
    main()