#!/usr/bin/env python

#Librarys
###########################################################################################
import hildon
import gtk
from threading import Thread
 
#Classes
###########################################################################################
class Windows(Thread):
	def __init__(self, parent):
		Thread.__init__(self)
		self.Parent = parent

	#Draw window
	def run(self):
		self.draw("", "main")

	#Draw window
	def draw(self, widget, name):
		#Create window
		self.win = hildon.StackableWindow()
		self.win.connect("destroy", gtk.main_quit, None)
		#Create menu
		menu = hildon.AppMenu()
		buttons = []
		buttons.append(hildon.GtkButton(gtk.HILDON_SIZE_AUTO))
		buttons.append(hildon.GtkButton(gtk.HILDON_SIZE_AUTO))
		buttons.append(hildon.GtkButton(gtk.HILDON_SIZE_AUTO))
		buttons[0].set_label("Emergency stop")
		buttons[1].set_label("About")
		buttons[2].set_label("Help")
		buttons[0].connect("clicked", self.Parent.Communicate.stopMachine)
		buttons[1].connect("clicked", self.Parent.About.open)
		buttons[2].connect("clicked", self.draw, "help")
		menu.append(buttons[0])
		menu.append(buttons[1])
		menu.append(buttons[2])

		self.statusButton = hildon.GtkRadioButton(gtk.HILDON_SIZE_AUTO, None)
		self.statusButton.set_label("Connect")
		self.statusButton.connect("clicked", self.Parent.Communicate.connection)
		menu.add_filter(self.statusButton)
		self.statusButton.set_mode(False)
	 
		self.statusButton = hildon.GtkRadioButton(gtk.HILDON_SIZE_AUTO, self.statusButton)
		self.statusButton.set_label("Disconnect")
		menu.add_filter(self.statusButton)
		self.statusButton.set_mode(False)

	 	menu.show_all()
		self.win.set_app_menu(menu)

		#Add content
		getattr(self, name+"Window")()

		self.win.show_all()

		#Connect, if needed
		if name == "main":
			self.Parent.Communicate.connection()

		#Draw
		gtk.main()

	def mainWindow(self):
		self.win.set_title("Bluetooth Coffeemaker")
		#Create buttons
		button = hildon.Button(gtk.HILDON_SIZE_AUTO, hildon.BUTTON_ARRANGEMENT_VERTICAL, "")
		button.set_image(gtk.image_new_from_file("cup.png"))
		button.connect("clicked", self.Parent.Communicate.startMachine)
		#Put buttons to box
		hbox = gtk.HBox(False, 0)
		hbox.pack_start(button, True, True, 0)
		#Add box to window
		self.win.add(hbox)

	def helpWindow(self):
		self.win.set_title("Bluetooth Coffeemaker: Help")
		#Create text
		text = gtk.TextBuffer()
		text.set_text("1. Start up your Bluetooth Coffeemaker\n2. Open the Bluetooth Coffeemaker -application on your mobilephone\n3. Connect to your Bluetooth Coffeemaker, if it didn't connect automaticly\n4. Click the coffee cup")
		#Create textview
		textview = gtk.TextView(buffer=text)
		textview.set_editable(False)
		textview.set_cursor_visible(False)
		#Put textview to box
		hbox = gtk.HBox(False, 0)
		hbox.pack_start(textview, True, True, 0)
		#Add box to window
		self.win.add(hbox)
