#!/usr/bin/env python

#Librarys
###########################################################################################
import commands
from bluetooth import *
from threading import Thread
 
#Classes
###########################################################################################
class Communicate(Thread):
	def __init__(self, parent):
		Thread.__init__(self)
		self.Parent = parent
		self.ignore = False
		self.connected = False
		self.startCode = chr(8) + chr(0) + chr(128) + chr(9) + chr(0)+ chr(4) + "fwd" + chr(0)
		self.stopCode = chr(0) + chr(1) #FIXME: doesn't do anything

	def run(self):
		pass

	def connection(self, ignore="", ignore2=""):
		if self.ignore:
			self.ignore = False
		else:
			if self.Parent.Windows.statusButton.get_active() == False and self.connected == False:
				commands.getoutput("dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:\"Connecting..\"")
				try:
					self.socket = BluetoothSocket(RFCOMM)
					self.socket.connect(("00:16:53:05:F8:3E", 1))
					commands.getoutput("dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:\"Connected to coffeemaker\"")
					self.connected = True
					if self.Parent.Windows.statusButton.get_active():
						self.ignore = True
						self.Parent.Windows.statusButton.set_active(0)
				except:
					commands.getoutput("dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:\"Failed to connect to coffeemaker\"")
					self.connected = False
					if self.Parent.Windows.statusButton.get_active() == False:
						self.ignore = True
						self.Parent.Windows.statusButton.set_active(1)
			elif self.Parent.Windows.statusButton.get_active() and self.connected:
				self.socket.close()
				commands.getoutput("dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:\"Disconnected\"")
				self.connected = False
				if self.Parent.Windows.statusButton.get_active() == False:
					self.ignore = True
					self.Parent.Windows.statusButton.set_active(1)

	def startMachine(self, ignore=""):
		if self.connected:
			try:
				self.socket.send(self.startCode)
				commands.getoutput("dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:\"Started coffeemaker\"")
			except:
				commands.getoutput("dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:\"Failed, try to reconnect\"")
		else:
			commands.getoutput("dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:\"You have to connect first\"")


	def stopMachine(self, ignore=""):
		if self.connected:
			try:
				self.socket.send(self.stopCode)
				commands.getoutput("dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:\"Stopped coffeemaker\"")
			except:
				commands.getoutput("dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:\"Failed, try to reconnect\"")
		else:
			commands.getoutput("dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:\"You have to connect first\"")
