#include "physicsscene.h"
#include <QDebug>


#include "athread.h"

PhysicsScene::PhysicsScene(QObject *parent) :
        QGraphicsScene(parent)
{
    mGravity= b2Vec2(0.0f,10.0f);
    createWorld();
    mTimer = new QTimer;
    mTimer->setInterval(20);
    mTime = QTime::currentTime();
    connect(mTimer,SIGNAL(timeout()),this,SLOT(mainLoop()));
    mFps = 20;

    aThread * accelerometer = new aThread(this);
    connect(accelerometer,SIGNAL(deviceOrientation(QString,QString,QString)),this,SLOT(moveXYZ(QString,QString,QString)));


    accelerometer->start(QThread::NormalPriority);
}
PhysicsScene::~PhysicsScene()
{

    delete mWorld;
}

void PhysicsScene::createWorld()
{

    b2AABB worldAABB;
    worldAABB.lowerBound.Set(-100.0f, -100.0f);
    worldAABB.upperBound.Set(100.0f, 100.0f);
    bool doSleep = false;
    mWorld = new b2World(worldAABB, mGravity, doSleep);

}
void PhysicsScene::addPhysicsItem(BoxItem * item)
{
    addItem(item);
    item->setup(mWorld);
    mBoxList.append(item);
}
void PhysicsScene::removePhysicsItem(BoxItem * item)
{
    mBoxList.removeOne(item);
    mWorld->DestroyBody(item->body());
    removeItem(item);

}

void PhysicsScene::computeSimulation(int32 iterations)
{

    double R = mFps/1000;

    float32 timeStep = R;
    mWorld->Step(timeStep, iterations);

    b2Body* node = mWorld->GetBodyList();
    while (node)
    {
        b2Body* b = node;
        node = node->GetNext();

        if ( b->GetUserData()!=NULL)
        {
            //            qDebug()<<"positionx:"<<b->GetPosition().x;
            //            q#include <phonon/MediaObject>
//qDebug()<<"positiony:"<<b->GetPosition().y;


            BoxItem* item = (BoxItem*)b->GetUserData();
            if (!item->needRemoveFromWorld())
                item->updatePhysics();

            else
            {
                mWorld->DestroyBody(item->body());
            }

        }
    }
}

void PhysicsScene::keyPressEvent(QKeyEvent *event)
{
    qDebug()<<"key press";

    computeSimulation();

}

void PhysicsScene::mainLoop()
{
    mFps = mTime.elapsed();
    mTime = QTime::currentTime();

    computeSimulation();


}

void PhysicsScene::start()
{
    mTimer->start();
}

void PhysicsScene::stop()
{





    mTimer->stop();

}

void PhysicsScene::moveXYZ(QString x, QString y, QString z)
{
#if defined(Q_WS_MAEMO_5)





        mWorld->SetGravity(b2Vec2(-x.toDouble()/10, -y.toDouble() / 10));

#endif

    }



