#ifndef BOXITEM_H
#define BOXITEM_H

#include <QGraphicsPolygonItem>
#include <QPixmap>
#include <QPainter>
#include "Box2D/Source/Box2D.h"

#define MAEMO_WIDTH 800
#define MAEMO_HEIGHT 480

class BoxItem : public QGraphicsPolygonItem
{
public:
    BoxItem(QRectF rect, bool isStatic = false);
    BoxItem(QPolygonF poly, bool isStatic = false);

    void setPolygonDef(b2PolygonDef p){m_polygonDef = p;}
    void setBodyDef(b2BodyDef b){m_bodyDef = b;}
    void initDensity(const float32 &d ){m_polygonDef.density = d;}
    void initFriction(const float32 &f){m_polygonDef.friction = f;}
    void initRestitution(const float32 &r){m_polygonDef.restitution = r;}
    void initSensor(bool b){m_polygonDef.isSensor = b;}
    void setMass(const float32 &m){m_bodyDef.massData.mass = m;}
    void initLinearDamping(const float32 &l){m_bodyDef.linearDamping = l;}
    void initAngularDamping(const float32 &a){m_bodyDef.angularDamping = a;}
    void initCategoryBits(const uint16 &c){m_polygonDef.filter.categoryBits = c;}
    void initMaskBits(const uint16 &c){m_polygonDef.filter.maskBits = c;}
    void initStatic(bool isStatic=true){mIsStatic=isStatic;}


    b2PolygonDef *polygonDef(){return &m_polygonDef;}
    b2BodyDef * bodyDef(){return &m_bodyDef;}
    inline const float32 &density(){return m_polygonDef.density;}
    inline const float32 &friction(){return m_polygonDef.friction;}
    inline const float32 &restition(){return m_polygonDef.restitution;}
    inline const float32 &mass(){return m_bodyDef.massData.mass; }
    inline bool isSensor(){return m_polygonDef.isSensor;}
    inline const float32 &linearDamping(){return m_bodyDef.linearDamping;}
    inline const float32 &angularDamping(){return m_bodyDef.angularDamping;}
    inline const uint16 &categoryBits(){return m_polygonDef.filter.categoryBits;}
    inline const uint16 &maskBits(){return m_polygonDef.filter.maskBits;}

    b2Body * body();



    void setup(b2World *world);
    void updatePhysics();

    void removeFromWorld()
    {
        mNeedRemoveFromWorld = true;
    }

    bool needRemoveFromWorld()
    {
        return mNeedRemoveFromWorld;
    }


protected:
    void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget);

private:
    b2PolygonDef m_polygonDef;
    b2BodyDef m_bodyDef;
    b2Body *m_body;
    bool mIsStatic;
    bool mNeedRemoveFromWorld;
    QPixmap mPixmap;
};

#endif // BOXITEM_H
