#include "normalblokitem.h"
#include <QDebug>

NormalBlokItem::NormalBlokItem(int width, int height,QObject *parent) :
        BlokItem(width,height,parent)
{

    mAnimationTimeLine = new QTimeLine;
    mAnimationTimeLine->setFrameRange(0,10);
    setBrush(QBrush(QPixmap(":sprites/normal_block.png")));

    connect(mAnimationTimeLine,SIGNAL(frameChanged(int)),this,SLOT(anim(int)));

}

void NormalBlokItem::mousePressEvent(QGraphicsSceneMouseEvent *event)
{



    mAnimationTimeLine->start();

    setBrush(Qt::white);
    QPen pen;
    pen.setColor(Qt::transparent);
    setPen(pen);

}

void NormalBlokItem::anim(int frame)
{
    qDebug()<<"anim";

    QColor c= brush().color();
    int alpha = c.alpha();

    alpha-= 255/9;

    qDebug()<<alpha;
    if ( alpha <=0)
    {
        qDebug()<<"remove";
        PhysicsScene * s = qobject_cast<PhysicsScene*>(scene());
        s->world()->DestroyBody(body());
        s->removeItem(this);
        return;
    }

    c.setAlpha(alpha);
    setBrush(QBrush(c));

}
