#include "blokgameview.h"

BlokGameView::BlokGameView(QWidget *parent) :
        QGraphicsView(parent)
{

    mScene = new PhysicsScene;
    mWallpaperItem = new QGraphicsPixmapItem;
    mGroundItem = new BoxItem(QRectF(0,430,800,50),true);

    setScene(mScene);


    mScene->addPhysicsItem(new BoxItem(QRectF(0,0,10,480),true));
    mScene->addPhysicsItem(new BoxItem(QRectF(790,0,10,480),true));
    mScene->addPhysicsItem(new BoxItem(QRectF(0,0,800,10),true));
    mScene->addPhysicsItem(new BoxItem(QRectF(0,470,800,10),true));


    //Level








    mScene->addItem(mWallpaperItem);
    mScene->addPhysicsItem(mGroundItem);

    setWallpaper(":sprites/sky_wallpaper.png");
    setGround(":sprites/green_ground.png");








    for ( int i=0; i<5; ++i)
    {

        NormalBlokItem * item =new NormalBlokItem(1,1);
        item->setPos(32,i*32);
        mScene->addPhysicsItem(item);

        NormalBlokItem * item2 =new NormalBlokItem(1,1);
        item2->setPos(40, i*32);
        mScene->addPhysicsItem(item2);



    }



mScene->addPhysicsItem(new SolidBlokItem(2,2));
mScene->addPhysicsItem(new SolidBlokItem(1,4));



    mScene->start();

}

void BlokGameView::setGround(const QString& path)
{
    mGroundItem->setBrush(QBrush(QPixmap(path)));
}

void BlokGameView::setWallpaper(const QString& path)
{

    mWallpaperItem->setPixmap(QPixmap(path));


}

void BlokGameView::mousePressEvent(QMouseEvent *event)
{

    if (event->button() == Qt::RightButton)
        mScene->stop();

    else
        mScene->start();



}

void BlokGameView::loadMap(const QString& path)
{


}
