from datetime import datetime
import gtk
import gobject
import hildon
import hildondesktop

class BinaryClockStatusAreaPlugin(hildondesktop.StatusMenuItem):
    def __init__(self):
        hildondesktop.StatusMenuItem.__init__(self)

        self.clockStyle = 0
        self.showSeconds = True

        self.time = None
        self.oldTime = None

        button = hildon.Button(gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL, "Binary Clock")
        image = gtk.Image()
        image.set_from_file("/usr/share/icons/hicolor/48x48/apps/binaryclock_status_area_plugin.png")
        button.set_image(image)
        button.set_alignment(0, 0.5, 0, 0)
        button.connect("clicked", self.settingsCb)
        self.add(button)
        button.show()

        self.drawingArea = gtk.DrawingArea()
      	self.drawingArea.connect("expose-event", self.exposeCb)

        self.set_status_area_widget(self.drawingArea)

        self.setSize()
      	self.drawingArea.show()

        self.show()

        gobject.timeout_add(1000, self.updateCb)

    def drawBcdClock(self):
        self.drawBitsVertically(2, 16, self.time.hour / 10, 2)
        self.drawBitsVertically(12, 0, self.time.hour % 10, 4)
        self.drawBitsVertically(26, 8, self.time.minute / 10, 3)
        self.drawBitsVertically(36, 0, self.time.minute % 10, 4)
        if self.showSeconds:
            self.drawBitsVertically(50, 8, self.time.second / 10, 3)
            self.drawBitsVertically(60, 0, self.time.second % 10, 4)

    def drawBinaryClock(self):
        self.drawBitsHorizontally(12, 2, self.time.hour, 5)
        self.drawBitsHorizontally(0, 14, self.time.minute, 6)
        if self.showSeconds:
            self.drawBitsHorizontally(0, 26, self.time.second, 6)

    def drawBitsHorizontally(self, x, y, value, n):
        for i in range(n):
            self.drawable.draw_arc(self.gc, (value >> (n - i - 1) & 1) > 0, x + 2 + (12 * i), y, 8, 8, 0, 360 *64)

    def drawBitsVertically(self, x, y, value, n):
        for i in range(n):
            self.drawable.draw_arc(self.gc, (value >> (n - i - 1) & 1) > 0, x, y + 1 + (8 * i), 6, 6, 0, 360 *64)

    def drawClock(self):
        if self.clockStyle == 0:
            self.drawBinaryClock()
        elif self.clockStyle == 1:
            self.drawBcdClock()
        else:
            self.drawBinaryClock()

    def exposeCb(self, widget, event):
        self.drawable = self.drawingArea.window
        self.gc = self.drawingArea.get_style().fg_gc[gtk.STATE_NORMAL]
        self.gc.foreground = self.drawingArea.get_colormap().alloc_color(65535, 65535, 65535)

        self.drawClock()
        return False

    def setSize(self):
        if (not self.showSeconds) and (self.clockStyle == 1):
            self.drawingArea.set_size_request(47, 36)
        else:
            self.drawingArea.set_size_request(76, 36)

    def settingsCb(self, widget, data=None):
        dialog = hildon.Dialog()
        dialog.set_title("Binary Clock Status Area Plugin Settings")

        self.showSecondsButton = hildon.CheckButton(gtk.HILDON_SIZE_FINGER_HEIGHT)
        self.showSecondsButton.set_active(self.showSeconds)
        self.showSecondsButton.set_label("Show seconds")
        dialog.vbox.pack_start(self.showSecondsButton, True, True, 0)
        self.showSecondsButton.show()

        self.selector = hildon.TouchSelector(text = True)
        self.selector.append_text("Binary Clock")
        self.selector.append_text("BCD Clock")
        self.styleButton = hildon.PickerButton(gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
        self.styleButton.set_title("Clock Style")
        self.styleButton.set_selector(self.selector)
        self.styleButton.set_active(self.clockStyle)
        dialog.vbox.pack_start(self.styleButton, True, True, 0)
        self.styleButton.show()

        okButton = hildon.Button(gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL, "Ok")
        okButton.connect("clicked", self.settingsOkCb, dialog)
        dialog.action_area.pack_start(okButton, True, True, 0)
        okButton.show()

        dialog.show_all()

    def settingsOkCb(self, widget, dialog):
        self.clockStyle = self.styleButton.get_active()
        self.showSeconds = self.showSecondsButton.get_active()

        self.setSize()
        self.drawingArea.queue_draw()
    
        dialog.destroy()

    def updateCb(self):
        if self.time != None:
            self.oldTime = self.time

        self.time = datetime.today()

        if self.showSeconds or (self.oldTime == None) or (self.oldTime.minute != self.time.minute):
            self.drawingArea.queue_draw()

        return True	


hd_plugin_type = BinaryClockStatusAreaPlugin


