#ifndef NETWORK_APPLICATION_H
#define NETWORK_APPLICATION_H

#include <QApplication>
#include <QNetworkConfigurationManager>
#include <QNetworkSession>
#include <GConfItem>
using namespace QtMobility;

class NetworkApplication : public QApplication
{
    Q_OBJECT

public:
    NetworkApplication(int &argc, char **argv);

private slots:
    void started();
    void valueChanged();
    void onlineStateChanged(bool isOnline);

private:
    QNetworkConfigurationManager *configManager;
    QNetworkSession *session;
    GConfItem *autoConnect;
    bool autoConnectValue;
};

#endif //NETWORK_APPLICATION_H
