#include <QMessageBox>
#include <QTimer>
#include <QNetworkConfiguration>

#include "networkapplication.h"

NetworkApplication::NetworkApplication(int &argc, char **argv) :
    QApplication(argc, argv), session(0)
{
    autoConnect = new GConfItem("/system/osso/connectivity/network_type/auto_connect",
                                this);
    valueChanged();
    connect(autoConnect, SIGNAL(valueChanged()), this, SLOT(valueChanged()));
    configManager = new QNetworkConfigurationManager(this);
    QTimer::singleShot(0, this, SLOT(started()));
}

void NetworkApplication::started()
{
    QCoreApplication::processEvents();
    onlineStateChanged(configManager->isOnline());
    connect(configManager, SIGNAL(onlineStateChanged(bool)),
            this, SLOT(onlineStateChanged(bool)));
}

void NetworkApplication::valueChanged()
{
    autoConnectValue = !(autoConnect->value().toString().isEmpty());
}

void NetworkApplication::onlineStateChanged(bool isOnline)
{
    if (!isOnline) {
        QMessageBox::StandardButton reply;
        if (autoConnectValue)
            reply = QMessageBox::Yes;
        else 
            reply = QMessageBox::question(0,
            "Connection",
            "This application requires connection to the Internet. "
            "Do you want to connect or quit an application?",
            QMessageBox::Yes | QMessageBox::No, QMessageBox::Yes);
        if (reply == QMessageBox::No)
            QCoreApplication::quit();
        else {
            if(session) {
                delete session;
                session = 0;
            }
            QNetworkConfiguration config = configManager->defaultConfiguration();
            session = new QNetworkSession(config, this);
            session->open();
            session->waitForOpened(-1);
            if(!autoConnectValue)
                onlineStateChanged(configManager->isOnline());
        }
    }
}
