#include <QDebug>
#include <QVBoxLayout>

#include "netmanager.h"

NetManager::NetManager(QWidget *parent)
    : QWidget(parent), nam(0)
{
    QVBoxLayout *layout = new QVBoxLayout;
    button = new QPushButton("Get page");
    connect(button, SIGNAL(clicked(bool)), this, SLOT(clicked(bool)));
    layout->addWidget(button);
    label = new QLabel("");
    layout->addWidget(label);
    setLayout(layout);
}

void NetManager::clicked(bool checked)
{
    Q_UNUSED(checked);

    if(!nam) {
        nam = new QNetworkAccessManager(this);
        connect(nam, SIGNAL(finished(QNetworkReply*)),
                this, SLOT(finished(QNetworkReply*)));
    }
    nam->get(QNetworkRequest(QUrl("http://tycho.usno.navy.mil/cgi-bin/timer.pl")));
}

void NetManager::finished(QNetworkReply *reply)
{
    if (reply->error() == QNetworkReply::NoError) {
        label->setText(reply->readAll());
    } else {
        label->setText(reply->errorString());
    }

    reply->deleteLater();
}
