#include "pinouts.h"
#include "ui_pinouts.h"

Pinouts::Pinouts(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::Pinouts)
{
    ui->setupUi(this);

    //Window Text
    this->setWindowTitle("Pinouts");
    this->setAttribute(Qt::WA_Maemo5StackedWindow);
    this->setWindowFlags(Qt::Window);

    //Set Button Text
    ui->pushButtonNetcable->setText(tr("Ethernet"));
    ui->pushButtonUsb->setText(tr("USB"));
    ui->pushButtonMonitor->setText(tr("VGA"));

    // Set Button Icons
    ui->pushButtonNetcable->setIcon(QPixmap("/opt/bander/icons/network_icon&32.png"));
    ui->pushButtonUsb->setIcon(QPixmap("/opt/bander/icons/connect_icon&32.png"));
    ui->pushButtonMonitor->setIcon(QPixmap("/opt/bander/icons/monitor_icon&32.png"));

    // For Connecting Keyboard Buttons
    connectSignals();
}

Pinouts::~Pinouts()
{
    delete ui;
}

// Keyboard Button Signals - remember to include QShortcut
void Pinouts::connectSignals()
{

// Keyboard Key Signals
   connect(new QShortcut(QKeySequence(Qt::Key_Backspace), this), SIGNAL(activated()), this, SLOT(close()));
  connect(new QShortcut(QKeySequence(Qt::Key_Q), this), SIGNAL(activated()), this, SLOT(on_pushButtonNetcable_clicked()));
  connect(new QShortcut(QKeySequence(Qt::Key_W), this), SIGNAL(activated()), this, SLOT(on_pushButtonUsb_clicked()));
  connect(new QShortcut(QKeySequence(Qt::Key_E), this), SIGNAL(activated()), this, SLOT(on_pushButtonMonitor_clicked()));
}


void Pinouts::on_pushButtonNetcable_clicked()
{
    Netcable *netcable = new Netcable(this);
    netcable->show();
}

void Pinouts::on_pushButtonUsb_clicked()
{
    Pusb *pusb = new Pusb(this);
    pusb->show();
}

void Pinouts::on_pushButtonMonitor_clicked()
{
    Pmonitor *pmonitor = new Pmonitor(this);
    pmonitor->show();
}
