#include "pusb.h"
#include "ui_pusb.h"

#include <QtCore/QCoreApplication>
#include <QShortcut>
#include <QPixmap>
#include <QColor>

Pusb::Pusb(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::Pusb)
{
    ui->setupUi(this);

    //Set Window
    this->setWindowTitle(tr("USB"));
    this->setAttribute(Qt::WA_Maemo5StackedWindow);
    this->setWindowFlags(Qt::Window);

    //Set A Image
    imgSceneA = new QGraphicsScene(ui->imgA);
    QGraphicsPixmapItem *itemA;
    QPixmap mImgA("/opt/bander/images/usb-pinout-4.jpg");
    ui->imgA->setScene(imgSceneA);
    mImgA = mImgA.scaled(QSize(180, 180), Qt::KeepAspectRatio);
    itemA = new QGraphicsPixmapItem(mImgA);
    imgSceneA->addItem(itemA);

    //Set B Image
    imgSceneB = new QGraphicsScene(ui->imgB);
    QGraphicsPixmapItem *itemB;
    QPixmap mImgB("/opt/bander/images/usb-pinout-5.jpg");
    ui->imgB->setScene(imgSceneB);
    mImgB = mImgB.scaled(QSize(180, 180), Qt::KeepAspectRatio);
    itemB = new QGraphicsPixmapItem(mImgB);
    imgSceneB->addItem(itemB);

    // Initial Pin Text
    ui->pin1->setText("Pin 1");
    ui->pin2->setText("Pin 2");
    ui->pin3->setText("Pin 3");
    ui->pin4->setText("Pin 4");
    ui->pin5->setText("Pin 5");

    // Initial Icons
    ui->icon1->setStyleSheet("background-color : #FF0000;");
    ui->icon2->setStyleSheet("background-color : #FFFFFF;");
    ui->icon3->setStyleSheet("background-color : #00FF00;");
    ui->icon4->setStyleSheet("background-color : #808080;");
    ui->icon5->setStyleSheet("background-color : #000000;");

    // Initial Description Text
    ui->label1->setText("Vbus [+5V]");
    ui->label2->setText("D- [Data -]");
    ui->label3->setText("D+ [Data +]");
    ui->label4->setText("ID [Host = GND]");
    ui->label5->setText("GND [Ground]");

    //Initial Button Settings
    ui->radioButtonFour->setChecked(false);
    ui->radioButtonFive->setChecked(true);

    //Initial Setup
    ui->imgA->hide();
    ui->imgB->show();

    /* Initial settings are 5 Pin
       so the table is loaded correctly */

    // For Connecting Keyboard Buttons
          connectSignals();
}

Pusb::~Pusb()
{
    delete ui;
}

// Keyboard Button Signals - remember to include QShortcut
void Pusb::connectSignals()
{
      connect(new QShortcut(QKeySequence(Qt::Key_Backspace), this), SIGNAL(activated()), this, SLOT(close()));
     connect(new QShortcut(QKeySequence(Qt::Key_Left), this), SIGNAL(activated()), this, SLOT(on_radioButtonFour_clicked()));
     connect(new QShortcut(QKeySequence(Qt::Key_Right), this), SIGNAL(activated()), this, SLOT(on_radioButtonFive_clicked()));
}

void Pusb::on_radioButtonFour_clicked()
{
    //Redraw the radiobuttons
    ui->radioButtonFour->setChecked(true);
    ui->radioButtonFive->setChecked(false);
    //Redraw the ui
    ui->imgB->hide();
    ui->imgA->show();
    ui->pin4->hide();
    ui->icon4->hide();
    ui->label4->hide();
    ui->pin5->setText("Pin 4");
}

void Pusb::on_radioButtonFive_clicked()
{
    //Redraw the radiobuttons
    ui->radioButtonFour->setChecked(false);
    ui->radioButtonFive->setChecked(true);
    //Redraw the ui
    ui->imgA->hide();
    ui->imgB->show();
    ui->pin4->show();
    ui->icon4->show();
    ui->label4->show();
    ui->pin5->setText("Pin 5");
}
