#include "ohmsa.h"
#include "ui_ohmsa.h"

#include <QtCore/QCoreApplication>
#include <QShortcut>
#include <QString>
#include <QLineEdit>
#include <QObject>
#include <math.h>

Ohmsa::Ohmsa(QWidget *parent) :
        QDialog(parent),
        ui(new Ui::Ohmsa)
{
    ui->setupUi(this);   
}

Ohmsa::~Ohmsa()
{
    delete ui;
}

//Voltage Tab

void Ohmsa::on_TV_pushButton_Calculate_clicked()
{
       int result = 0;
       long iNumber = 10;
       QString str = QString::number(iNumber);
       bool ok;
       int value1 = ui->TV_lineEdit_I->text().toInt(&ok, 10);
       int value2 = ui->TV_lineEdit_R->text().toInt(&ok, 10);
       result = value1*value2;
       ui->TV_lineEdit_V->setText(str.setNum(result));
}

void Ohmsa::on_TV_pushButton_Clear_clicked()
{
       ui->TV_lineEdit_V->setText(tr(""));
       ui->TV_lineEdit_I->setText(tr(""));
       ui->TV_lineEdit_R->setText(tr(""));
}

//Current Tab

void Ohmsa::on_TI_pushButton_Calculate_clicked()
{
       int result = 0;
       long iNumber = 10;
       QString str = QString::number(iNumber);
       bool ok;
       int value1 = ui->TI_lineEdit_V->text().toInt(&ok, 10);
       int value2 = ui->TI_lineEdit_R->text().toInt(&ok, 10);
       result = value1/value2;
       ui->TI_lineEdit_I->setText(str.setNum(result));
}

void Ohmsa::on_TI_pushButton_Clear_clicked()
{
       ui->TI_lineEdit_V->setText(tr(""));
       ui->TI_lineEdit_I->setText(tr(""));
       ui->TI_lineEdit_R->setText(tr(""));
}

//Resistance Tab

void Ohmsa::on_TR_pushButton_Calculate_clicked()
{
       int result = 0;
       long iNumber = 10;
       QString str = QString::number(iNumber);
       bool ok;
       int value1 = ui->TR_lineEdit_V->text().toInt(&ok, 10);
       int value2 = ui->TR_lineEdit_I->text().toInt(&ok, 10);
       result = value1/value2;
       ui->TR_lineEdit_R->setText(str.setNum(result));
}

void Ohmsa::on_TR_pushButton_Clear_clicked()
{
       ui->TR_lineEdit_V->setText(tr(""));
       ui->TR_lineEdit_I->setText(tr(""));
       ui->TR_lineEdit_R->setText(tr(""));

}
