#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui/QMainWindow>

class About;
class Help;
class wResistors;
class Ohmsa;
class Power;

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT
public:
    enum ScreenOrientation {
        ScreenOrientationLockPortrait,
        ScreenOrientationLockLandscape,
        ScreenOrientationAuto
    };

    explicit MainWindow(QWidget *parent = 0);
    virtual ~MainWindow();

    // Note that this will only have an effect on Symbian and Fremantle.
    void setOrientation(ScreenOrientation orientation);

    void showExpanded();


private slots:

    void on_actionAbout_triggered();

    void on_actionHelp_triggered();

    void on_pushButtonResistor_clicked();

    void on_pushButtonOhmsa_clicked();

    void on_pushButtonPower_clicked();

private:
    Ui::MainWindow *ui;
    About *about;
    Help *help;
    wResistors *wresistors;
    Ohmsa *ohmsa;
    Power *power;

};

#endif // MAINWINDOW_H
