#include "dialogday.h"
#include "ui_dialogday.h"
#include <QDebug>
#include <QtMaemo5/QMaemo5TimePickSelector>
#include <QtMaemo5/QMaemo5ValueButton>

DialogDay::DialogDay(QWidget *parent) :
    QDialog(parent)/*,
    m_ui(new Ui::DialogDay)*/
{
    //m_ui->setupUi(this);
    setAttribute(Qt::WA_Maemo5StackedWindow);


    this->resize(319, 236);

    gridLayout = new QGridLayout(this);
    gridLayout->setObjectName(QString::fromUtf8("gridLayout"));
    horizontalLayout = new QHBoxLayout();
    horizontalLayout->setObjectName(QString::fromUtf8("horizontalLayout"));
    label = new QLabel(this);
    label->setObjectName(QString::fromUtf8("label"));

    horizontalLayout->addWidget(label);

    timeEditEntrance = new QMaemo5ValueButton("Entrance");
    //timeEditEntrance->setIcon(QIcon::fromTheme("chat_smiley_tongue"));
    timeEditEntrance->setValueLayout(QMaemo5ValueButton::ValueUnderText);
    timeEditEntrance->setPickSelector(new QMaemo5TimePickSelector());
    timeEditEntrance->setObjectName(QString::fromUtf8("timeEditEntrance"));
    //timeEditEntrance->setMinimumSize(QSize(100, 0));
    horizontalLayout->addWidget(timeEditEntrance);


    label_2 = new QLabel(this);
    label_2->setObjectName(QString::fromUtf8("label_2"));

    horizontalLayout->addWidget(label_2);

    timeEditExit = new QMaemo5ValueButton("Exit");
    timeEditExit->setPickSelector(new QMaemo5TimePickSelector());
    timeEditExit->setValueLayout(QMaemo5ValueButton::ValueUnderText);
    timeEditExit->setObjectName(QString::fromUtf8("timeEditExit"));
    timeEditExit->setMinimumSize(QSize(100, 0));

    horizontalLayout->addWidget(timeEditExit);


    gridLayout->addLayout(horizontalLayout, 0, 0, 1, 1);

    checkBoxFirst = new QCheckBox(this);
    checkBoxFirst->setObjectName(QString::fromUtf8("checkBoxFirst"));

    gridLayout->addWidget(checkBoxFirst, 1, 0, 1, 1);

    horizontalLayout_2 = new QHBoxLayout();
    horizontalLayout_2->setObjectName(QString::fromUtf8("horizontalLayout_2"));
    label_3 = new QLabel(this);
    label_3->setObjectName(QString::fromUtf8("label_3"));

    horizontalLayout_2->addWidget(label_3);

    timeEditFBegin = new QMaemo5ValueButton("First Pause Begin");
    timeEditFBegin->setPickSelector(new QMaemo5TimePickSelector());
    timeEditFBegin->setObjectName(QString::fromUtf8("timeEditFBegin"));
    timeEditFBegin->setEnabled(false);
    timeEditFBegin->setMinimumSize(QSize(100, 0));

    horizontalLayout_2->addWidget(timeEditFBegin);

    label_4 = new QLabel(this);
    label_4->setObjectName(QString::fromUtf8("label_4"));

    horizontalLayout_2->addWidget(label_4);

    timeEditEndF = new QMaemo5ValueButton("First Pause End");
    timeEditEndF->setPickSelector(new QMaemo5TimePickSelector());
    timeEditEndF->setObjectName(QString::fromUtf8("timeEditEndF"));
    timeEditEndF->setEnabled(false);
    timeEditEndF->setMinimumSize(QSize(100, 0));

    horizontalLayout_2->addWidget(timeEditEndF);


    gridLayout->addLayout(horizontalLayout_2, 2, 0, 1, 1);

    checkBoxSecond = new QCheckBox(this);
    checkBoxSecond->setObjectName(QString::fromUtf8("checkBoxSecond"));

    gridLayout->addWidget(checkBoxSecond, 3, 0, 1, 1);

    horizontalLayout_3 = new QHBoxLayout();
    horizontalLayout_3->setObjectName(QString::fromUtf8("horizontalLayout_3"));
    label_5 = new QLabel(this);
    label_5->setObjectName(QString::fromUtf8("label_5"));

    horizontalLayout_3->addWidget(label_5);

    timeEditSBegin = new QMaemo5ValueButton("Second Pause Begin");
    timeEditSBegin->setPickSelector(new QMaemo5TimePickSelector());
    timeEditSBegin->setObjectName(QString::fromUtf8("timeEditSBegin"));
    timeEditSBegin->setEnabled(false);
    timeEditSBegin->setMinimumSize(QSize(100, 0));

    horizontalLayout_3->addWidget(timeEditSBegin);

    label_6 = new QLabel(this);
    label_6->setObjectName(QString::fromUtf8("label_6"));

    horizontalLayout_3->addWidget(label_6);

    timeEditEndS = new QMaemo5ValueButton("Second Pause End");
    timeEditEndS->setPickSelector(new QMaemo5TimePickSelector());
    timeEditEndS->setObjectName(QString::fromUtf8("timeEditEndS"));
    timeEditEndS->setEnabled(false);
    timeEditEndS->setMinimumSize(QSize(100, 0));

    horizontalLayout_3->addWidget(timeEditEndS);


    gridLayout->addLayout(horizontalLayout_3, 4, 0, 1, 1);

    buttonBox = new QDialogButtonBox(this);
    buttonBox->setObjectName(QString::fromUtf8("buttonBox"));
    buttonBox->setOrientation(Qt::Horizontal);
    buttonBox->setStandardButtons(QDialogButtonBox::Cancel|QDialogButtonBox::Ok);

    gridLayout->addWidget(buttonBox, 5, 0, 1, 1);


    //retranslateUi(this);
    connect(buttonBox, SIGNAL(accepted()), this, SLOT(accept()));
    connect(buttonBox, SIGNAL(rejected()), this, SLOT(reject()));
    connect(checkBoxFirst, SIGNAL(clicked(bool)), this, SLOT(enableFirst(bool)));
    connect(checkBoxSecond, SIGNAL(clicked(bool)), this, SLOT(enableSecond(bool)));

    //QMetaObject::connectSlotsByName(this);

   /* QVBoxLayout *lay = new QVBoxLayout(this);

    QMaemo5ValueButton *v3 = new QMaemo5ValueButton(tr("Picker"));
    v3->setIcon(QIcon::fromTheme("chat_smiley_tongue"));
    v3->setValueLayout(QMaemo5ValueButton::ValueUnderText);
    v3->setPickSelector(new QMaemo5TimePickSelector());
    //buttons->addButton(v3);
    lay->addWidget(v3);*/



}

DialogDay::~DialogDay()
{
    //delete m_ui;
}

void DialogDay::changeEvent(QEvent *e)
{
    /*QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        m_ui->retranslateUi(this);
        break;
    default:
        break;
    }*/
}

void DialogDay::enableFirst(bool enable)
{
    timeEditFBegin->setEnabled(enable);
    timeEditEndF->setEnabled(enable);
}

void DialogDay::enableSecond(bool enable)
{
    timeEditSBegin->setEnabled(enable);
    timeEditEndS->setEnabled(enable);
}


TimeTable DialogDay::getTimes(TimeTable timetable)
{
    //qDebug () << "ENT " << timetable.entrance.toString("hh:mm") << endl;
    timeEditEntrance->setValueText(timetable.entrance.toString("hh:mm") /*+ ":00"*/);
    timeEditExit->setValueText(timetable.exit.toString("hh:mm")/* + ":00"*/);
    timeEditFBegin->setValueText(timetable.firstPause.toString("hh:mm") /*+ ":00" */);
    timeEditEndF->setValueText(timetable.endFirstPause.toString("hh:mm")/* + ":00"*/ );
    timeEditSBegin->setValueText(timetable.secondPause.toString("hh:mm") /*+ ":00"*/);
    timeEditEndS->setValueText(timetable.endSecondPause.toString("hh:mm")/* + ":00"*/);

    checkBoxFirst->setChecked(false);
    checkBoxSecond->setChecked(false);

    if (timetable.firstPause != timetable.endFirstPause) {
        checkBoxFirst->setChecked(true);
        timeEditFBegin->setValueText(timetable.firstPause.toString("hh:mm")/* + ":00"*/);
        timeEditFBegin->setEnabled(true);
        timeEditEndF->setValueText(timetable.endFirstPause.toString("hh:mm") /*+ ":00"*/);
        timeEditEndF->setEnabled(true);
    }
    if (timetable.secondPause != timetable.endSecondPause) {
        checkBoxSecond->setChecked(true);
        timeEditSBegin->setValueText(timetable.secondPause.toString("hh:mm") /*+ ":00"*/);
        timeEditSBegin->setEnabled(true);
        timeEditEndS->setValueText(timetable.endSecondPause.toString("hh:mm")/* + ":00"*/);
        timeEditEndS->setEnabled(true);
    }


    if (this->exec() == QDialog::Accepted) {


        timetable.entrance =  QTime::fromString(timeEditEntrance->valueText(), "hh:mm");
        timetable.exit =  QTime::fromString(timeEditExit->valueText(), "hh:mm");
        if (checkBoxFirst->isChecked()) {

            timetable.firstPause = QTime::fromString(timeEditFBegin->valueText(), "hh:mm");
            timetable.endFirstPause = QTime::fromString(timeEditEndF->valueText(), "hh:mm");
        }
        if (checkBoxSecond->isChecked()) {
            timetable.secondPause = QTime::fromString(timeEditSBegin->valueText(), "hh:mm");
            timetable.endSecondPause = QTime::fromString(timeEditEndS->valueText(), "hh:mm");
        }
        return timetable;
    }
    timetable.setWrong(true);
    return timetable;
}


