
function autopagerMicrob() { }

autopagerMicrob.prototype = {
    pref: Components.classes["@mozilla.org/preferences-service;1"].
    getService(Components.interfaces.nsIPrefService).getBranch("autopager"),
    LOG : function (text)
    {
        var consoleService = Components.classes["@mozilla.org/consoleservice;1"].getService(Components.interfaces.nsIConsoleService);
        consoleService.logStringMessage(text);
    },
    observe: function(subject, topic, data)
    {    
        if (topic == "app-startup") {
            var observerService = Components.classes["@mozilla.org/observer-service;1"]
            .getService(Components.interfaces.nsIObserverService);
            observerService.addObserver(this, "domwindowopened", false);
            observerService.addObserver(this, "quit-application-requested", false);

            var loader = Components.classes['@mozilla.org/moz/jssubscript-loader;1']
            .getService(Components.interfaces.mozIJSSubScriptLoader);

            this.LOG(topic + ":" + loader);
            loader.loadSubScript("chrome://autopager/content/autopager-bw-utils.js");
            loader.loadSubScript("chrome://autopager/content/autopager-strings.js");
            loader.loadSubScript("chrome://autopager/content/autopager-utils.js");
            loader.loadSubScript("chrome://autopager/content/autopager-pref.js");
            loader.loadSubScript("chrome://autopager/content/splitbrowse.js");
            loader.loadSubScript("chrome://autopager/content/convert2RegExp.js");
            loader.loadSubScript("chrome://autopager/content/apxmlhttp.js");
            loader.loadSubScript("chrome://autopager/content/autopagerize.js");
            loader.loadSubScript("chrome://autopager/content/json.js");
            loader.loadSubScript("chrome://autopager/content/autopager-lite.js");
            loader.loadSubScript("chrome://autopager/content/autopager-rules.js");
            loader.loadSubScript("chrome://autopager/content/autopager-updatesites.js");
            loader.loadSubScript("chrome://autopager/content/autoConfig.js");
            loader.loadSubScript("chrome://autopager/content/autopager-json.js");
            loader.loadSubScript("chrome://autopager/content/autopager.js");
            loader.loadSubScript("chrome://autopager/content/autopager-paging.js");
            loader.loadSubScript("chrome://autopager/content/autopager-toolbar.js");
            loader.loadSubScript("chrome://autopager/content/autopager-troubleshoting.js");
            loader.loadSubScript("chrome://autopager/content/autopager-sitesetting.js");

            autopagerPref.init();
            var docLoaderSvc = Components.classes["@mozilla.org/docloaderservice;1"].getService(Components.interfaces.nsIWebProgress);

            docLoaderSvc.addProgressListener(this, Components.interfaces.nsIWebProgress.NOTIFY_ALL);
        }
        else if (topic == "domwindowopened") {
            //            useragentswitcher_initialize();
            this.LOG("domwindowopened:" + data)
            

            if (typeof document != "undefined")
                document.splitBrowserCount = 0;

        }
        else if (topic == "quit-application-requested") {
    //            /* FIXME - this observer is not working */
    //            var event = null;
    //            useragentswitcher_uninitialize(event);
    //            initialized = false;
        
    }
    },
    QueryInterface: function (iid) {
        if (iid.equals(Components.interfaces.nsIObserver) ||
            iid.equals(Components.interfaces.nsISupports) ||
            iid.equals(Components.interfaces.nsISupportsWeakReference) ||
            iid.equals(Components.interfaces.nsIWebProgressListener)
                )
            return this;

        Components.returnCode = Components.results.NS_ERROR_NO_INTERFACE;
        return null;
    },
    // nsIWebProgressListener
    onStateChange: function onStateChange(aWebProgress, aRequest, aStateFlags, aStatus)
    {
        if (aStateFlags & Components.interfaces.nsIWebProgressListener.STATE_STOP &&
            aStateFlags & Components.interfaces.nsIWebProgressListener.STATE_IS_NETWORK && aStatus==0) {
            //                listen(curWindow.document, "DOMContentLoaded", hitch(this, "contentLoaded"));
            try{
                content = aWebProgress.DOMWindow
                document = content.document
                this.LOG("document loaded:" + document)

                var curWindow = aWebProgress.DOMWindow.document.defaultView;
                this.LOG(1)
                window = curWindow
                window.setTimeout(function(){
                    autopagerLite.onContentLoad(document)
                    }, 250);
            
                this.LOG(20)
                autopagerLite.apRuleSiteOnInit();
                this.LOG(30)
                window.addEventListener("load",splitbrowse.init,false);
                this.LOG(40)

                autopagerMain.autopagerOnLoad();
                this.LOG(50)
                autopagerMain.onContentLoad(document);
                window.addEventListener("unload", autopagerSanitizer.onWindowClose, false);
                //autopagerSiteSetting.onInit();
                //window.alert(document.location)
                window.setTimeout(autopagerToolbar.autopagerToobarInit, 250);
            //            autopagerToolbar.autopagerToobarInit();
            //            window.addEventListener("load", function() {
            //                var self = arguments.callee;
            //                window.removeEventListener("load",self,false);
            //                window.setTimeout(autopagerToolbar.autopagerToobarInit, 250);
            //            }, false);
            }catch(e)
            {
                this.LOG("error :" + e)

            }

        }


    //        if (aStateFlags & Components.interfaces.nsIWebProgressListener.STATE_IS_REQUEST &&
    //            aStateFlags & Components.interfaces.nsIWebProgressListener.STATE_IS_DOCUMENT) {
    //            listen(curWindow.document, "DOMContentLoaded", hitch(this, "contentLoaded"));
    //        }
    },

    onProgressChange: function onProgressChange(wp, r, csp, msp, ctp, mtp) {},
    onLocationChange: function onLocationChange(wp, r, l) {},
    onStatusChange: function onStatusChange(wp, r, s, m) {},
    onSecurityChange: function onSecurityChange(wp, r, s) {}
};

var autopagerMicrobModule = {
    registerSelf: function (compMgr, fileSpec, location, type) {

        var compMgr = compMgr.QueryInterface(Components.interfaces.nsIComponentRegistrar);
        compMgr.registerFactoryLocation(this.myCID,
            this.myName,
            this.myProgID,
            fileSpec,
            location,
            type);


        var catMgr = Components.classes["@mozilla.org/categorymanager;1"].getService(Components.interfaces.nsICategoryManager);
        catMgr.addCategoryEntry("app-startup", this.myName, this.myProgID, true, true);
    },


    getClassObject: function (compMgr, cid, iid) {
        return this.myFactory;
    },

    myCID: Components.ID("{37d29da9-ef2e-4e2b-a7e9-254078b62dd7}"),

    myProgID: "@autopager.teesoft.info/autopagerMicrob;1",

    myName:   "AutoPager Microb loader",

    myFactory: {
        QueryInterface: function (aIID) {
            if (!aIID.equals(Components.interfaces.nsISupports) &&
                !aIID.equals(Components.interfaces.nsIFactory))
                throw Components.results.NS_ERROR_NO_INTERFACE;
            return this;
        },

        createInstance: function (outer, iid) {
            return new autopagerMicrob();
        }
    },

    canUnload: function(compMgr) {
        return true;
    }
};

function NSGetModule(compMgr, fileSpec) {
    return autopagerMicrobModule;
}
