#include "mainwindow.h"
#include "ui_mainwindow.h"

#include <QMessageBox>

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);
    connect(ui->actionHelp, SIGNAL(triggered()), this, SLOT(showHelp()));
    connect(ui->actionAbout, SIGNAL(triggered()), this, SLOT(showAbout()));
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::showHelp()
{
    QString helpText;

    helpText.append("<h2>AutoConnect "+tr("Hilfe") +"</h2>");
    helpText.append("<p>"+ tr("Bietet zustzliche Suchintervalle fr den automatischen Verbindungsaufbau zum Internet.")+"<br/>");
    helpText.append(tr("Zur Nutzung von AutoConnect sollte ein Datentarif vorhanden sein, da ansonsten erhebliche Mehrkosten entstehen knnen.")+"<br/>");
    QMessageBox::about(this, tr("Hilfe"),
                       helpText);
}

void MainWindow::showAbout()
{
    QString about;
    about.append("<h2>AutoConnect</h2>");
    about.append(tr("Entwickelt in Qt %1<br/>").arg(QString(QT_VERSION_STR)));
    about.append(tr("Copyright") + " 2010 - MeeGo.de<br/><br/> Code: &lt;DuKe@meego.de&gt; <br/> Code: &lt;Xarthas@meego.de&gt; <br/> Gui: &lt;NightShift79@meego.de&gt;<br/><br/>");
    about.append(tr("Besucht <a href=http://meego.de>http://meego.de</a> um feedback zu geben und ber Bugs zu berichten. Danke.</p>"));

    QMessageBox::about(this, tr("ber AutoConnect"),
                       about);
}



void MainWindow::on_pushButton_clicked()
{

    system("gconftool -s -t int /system/osso/connectivity/network_type/search_interval 120");

}

void MainWindow::on_pushButton_2_clicked()
{
    system("gconftool -s -t int /system/osso/connectivity/network_type/search_interval 300");
}

void MainWindow::on_pushButton_3_clicked()
{
    system("gconftool -s -t int /system/osso/connectivity/network_type/search_interval 7200");
}

void MainWindow::on_pushButton_5_clicked()
{
    system("gconftool -s -t int /system/osso/connectivity/network_type/search_interval 10800");
}

void MainWindow::on_pushButton_4_clicked()
{
    system("gconftool -s -t int /system/osso/connectivity/network_type/search_interval 14400");
}

void MainWindow::on_pushButton_6_clicked()
{
    system("gconftool -s -t int /system/osso/connectivity/network_type/search_interval 18000");
}

void MainWindow::on_pushButton_7_clicked()
{
    system("gconftool -s -t int /system/osso/connectivity/network_type/search_interval 0");
}
