#include "mainwindow.h"
#include "ui_mainwindow.h"

#include <QtCore/QCoreApplication>
#include <QDesktopServices>
#ifdef Q_WS_MAEMO5
#include <QtMaemo5/QMaemo5InformationBox>
#endif
#include <QProcess>


MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent), ui(new Ui::MainWindow)
{
    ui->setupUi(this);
    articleList = new ArticleList(this);
    articleList->hide();
    playlist = new Playlist(this);
    playlist->hide();
    player = new Player(this);
    player->hide();
    options = new Options(this);
    options->hide();
    network = new Network();
    openPlaylist = false;

    message = new QProgressDialog("", "Cancel", 0, -1, this);

    QString program = "mkdir";
    QStringList arguments;
    arguments << "/home/user/MyDocs/.audiowiki";
    QProcess *myProcess = new QProcess();
    myProcess->start(program, arguments);

    this->toPlaylist = false;

    connect(articleList, SIGNAL(articleSelected(QTableWidgetItem*)), this, SLOT(article_selected(QTableWidgetItem*)));
    connect(playlist, SIGNAL(articleSelected(QTreeWidgetItem*, int)), this, SLOT(playlist_item_selected(QTreeWidgetItem*, int)));
    connect(options, SIGNAL(closeButtonClicked()), this, SLOT(close()));
    connect(articleList, SIGNAL(addToPlaylistClicked()), this, SLOT(addToPlaylistClicked()));
    connect(playlist, SIGNAL(playlistSelected(QList<QTreeWidgetItem*>,int)), this, SLOT(playlist_selected(QList<QTreeWidgetItem*>,int)));
    connect(options, SIGNAL(clearCurrentClicked()), player, SLOT(clear()));
    connect(network, SIGNAL(searchTitlesReceived(QList<QString>)), this, SLOT(openArticleList(QList<QString>)));
    connect(articleList, SIGNAL(newSearch(QString)), this, SLOT(newSearch(QString)));
    connect(network, SIGNAL(articleContentReceived(QString,QString)), this, SLOT(openArticleInPlayer(QString,QString)));
    connect(articleList, SIGNAL(articleToPlaylist(QString,QString)), this, SLOT(addToPlaylist(QString,QString)));
    connect(network, SIGNAL(playlistArticleSaved(QString)), this, SLOT(articleSaved(QString)));
    connect(player, SIGNAL(openArticleFromLink(QListWidgetItem*)), this, SLOT(openArticleFromLink(QListWidgetItem*)));
    connect(player, SIGNAL(audioCreated()), this, SLOT(audioCreated()));
    connect(player,SIGNAL(playListFileAdded()), this, SLOT(openPlaylistFiles()));
   // connect(network, SIGNAL(downloadProgress(qint64,qint64)), this, SLOT(updateProgressBar(qint64,qint64)));
}

MainWindow::~MainWindow()
{
    network->deleteLater();
    delete ui;
}

void MainWindow::setOrientation(ScreenOrientation orientation)
{
#if defined(Q_OS_SYMBIAN)
    // If the version of Qt on the device is < 4.7.2, that attribute won't work
    if (orientation != ScreenOrientationAuto) {
        const QStringList v = QString::fromAscii(qVersion()).split(QLatin1Char('.'));
        if (v.count() == 3 && (v.at(0).toIntarticleCon() << 16 | v.at(1).toInt() << 8 | v.at(2).toInt()) < 0x040702) {
            qWarning("Screen orientation locking only supported with Qt 4.7.2 and above");
            return;
        }
    }((articleContentReceived(QString), this, SLOT(openArticleInPlayer(QString)));)ar)
#endif // Q_OS_SYMBIAN

    Qt::WidgetAttribute attribute;
    switch (orientation) {
#if QT_VERSION < 0x040702
    // Qt < 4.7.2 does not yet have the Qt::WA_*Orientation attributes
    case ScreenOrientationLockPortrait:
        attribute = static_cast<Qt::WidgetAttribute>(128);
        break;
    case ScreenOrientationLockLandscape:
        attribute = static_cast<Qt::WidgetAttribute>(129);
        break;
    default:
    case ScreenOrientationAuto:
        attribute = static_cast<Qt::WidgetAttribute>(130);
        break;
#else // QT_VERSION < 0x040702
    case ScreenOrientationLockPortrait:
        attribute = Qt::WA_LockPortraitOrientation;
        break;
    case ScreenOrientationLockLandscape:
        attribute = Qt::WA_LockLandscapeOrientation;
        break;
    default:
    case ScreenOrientationAuto:
        attribute = Qt::WA_AutoOrientation;
        break;
#endif // QT_VERSION < 0x040702
    };
    setAttribute(attribute, true);
}
void MainWindow::showExpanded()
{
#ifdef Q_OS_SYMBIAN
    showFullScreen();
#elif defined(Q_WS_MAEMO_5)
    showMaximized();
#else
    show();
#endif
}

void MainWindow::on_searchButton_clicked()
{


   /* if (articleList->isVisible())
        articleList->hide();
    else
    {
        articleList->show();
    }
    if (playlist->isVisible())
        playlist->hide();
    else if (player->isVisible())
        player->hide();
    if (options->isVisible())
        options->hide();*/
    if (this->ui->searchLineEdit->text().isEmpty())
    {
        #ifdef Q_WS_MAEMO5
        QMaemo5InformationBox::information(this, "Please enter search word first",
                                                    QMaemo5InformationBox::DefaultTimeout);
        #endif
    }
    else
    {
        message->setLabelText("Searching");
        message->show();
        network->searchKeyWord(this->ui->searchLineEdit->text());
        this->searchWord = this->ui->searchLineEdit->text();
        this->ui->label->hide();
        this->ui->label->setHidden(true);
        this->ui->label_2->setHidden(true);
        this->ui->searchLineEdit->clear();
    }
}

void MainWindow::on_mainWindowButton_clicked()
{
    if (!articleList->isVisible())
    {
        ui->mainWindowButton->setDown(true);
        articleList->show();
        this->ui->label->hide();
        this->ui->label_2->hide();
    }
    else
    {
        articleList->hide();
        ui->mainWindowButton->setDown(false);
    }
    if (playlist->isVisible())
    {
        ui->playlistsButton->setDown(false);
        playlist->hide();
    }
    else if (player->isVisible())
    {
        player->hide();
        ui->playerButton->setDown(false);
    }
    if (options->isVisible())
    {
        options->hide();
    }
    this->ui->label->hide();
    this->ui->label_2->hide();
}

void MainWindow::on_playlistsButton_clicked()
{
    if (playlist->isVisible())
    {
        playlist->hide();
        ui->playlistsButton->setDown(false);
    }
    else
    {
        playlist->show();
        ui->playlistsButton->setDown(true);
        this->ui->label->hide();
        this->ui->label_2->hide();
    }
    if (articleList->isVisible())
    {
        articleList->hide();
        ui->mainWindowButton->setDown(false);
    }
    else if (player->isVisible())
    {
        player->hide();
        ui->playerButton->setDown(false);
    }
    if (options->isVisible())
        options->hide();
    this->ui->label->hide();
    this->ui->label_2->hide();
}
void MainWindow::on_playerButton_clicked()
{
    if (player->isVisible())
    {
        player->hide();
        ui->playerButton->setDown(false);
    }
    else
    {
        player->show();
        ui->playerButton->setDown(true);
        this->ui->label->hide();
        this->ui->label_2->hide();
    }
    if (articleList->isVisible())
    {
        articleList->hide();
        ui->mainWindowButton->setDown(false);
    }
    else if (playlist->isVisible())
    {
        playlist->hide();
        ui->playlistsButton->setDown(false);
    }
    if (options->isVisible())
        options->hide();
    this->ui->label->hide();
    this->ui->label_2->hide();
}

void MainWindow::article_selected(QTableWidgetItem *item)
{
    message->setLabelText("Loading " + item->text());
    QString stripped = item->text().toLower().remove(QRegExp("[^A-Za-z0-9]"));
    message->show();
    bool existsAlready = QFile("/home/user/MyDocs/.audiowiki/" +  stripped+".txt").exists();
    network->retrieveArticle(item->text(), existsAlready);
}

void MainWindow::openArticleFromLink(QListWidgetItem *item)
{
    if (player->isVisible())
        player->hide();
    message->setLabelText("Loading " + item->text());
    message->show();

    QString stripped = item->text().toLower().remove(QRegExp("[^A-Za-z0-9]"));

    bool existsAlready = QFile("/home/user/MyDocs/.audiowiki/" +  stripped+".txt").exists();
    qDebug()<<"openarticlefromlink"<<stripped<<existsAlready;
    network->retrieveArticle(item->text(), existsAlready);
}

void MainWindow::playlist_item_selected(QTreeWidgetItem *item, int column)
{
    message->setLabelText("Opening " + item->text(column));
    message->show();
    QString stripped = item->text(column).toLower().remove(QRegExp("[^A-Za-z0-9]"));
    bool existsAlready = QFile("/home/user/MyDocs/.audiowiki/" +  stripped+".txt").exists();

    network->retrieveArticle(item->text(column), existsAlready);
}

void MainWindow::on_optionsButton_clicked()
{
    if (options->isVisible())
        options->hide();
    else
        options->show();
}

void MainWindow::addToPlaylistClicked()
{
    this->toPlaylist = true;
    QStringList list = playlist->getPlaylists();

    articleList->openSplashScreen(list);
}

void MainWindow::playlist_selected(QList<QTreeWidgetItem *> items, int column)
{

    this->playlistList = items;
    this->playlistColumn = column;
    qDebug()<<"in main with playlistitems";
    player->clearCurrentArticles();
    openPlaylist = true;
    int i = 0;
    while (i<this->playlistList.count())
    {
        if(this->playlistList.count()>i)
        {
             QString stripped = this->playlistList.at(i)->text(column).toLower().remove(QRegExp("[^A-Za-z0-9]"));
            bool existsAlready = QFile("/home/user/MyDocs/.audiowiki/" +  stripped+".txt").exists();
            qDebug()<<this->playlistList.at(i)->text(column)<<existsAlready;
            network->retrieveArticle(this->playlistList.at(i)->text(column), existsAlready);

        }
        i++;
    }


}

void MainWindow::openPlaylistFiles()
{
    if (!this->playlistList.isEmpty())
    {
        if (this->playlistList.count() < 1)
        {
            if(!player->isVisible())
                player->show();
        }
        else if (this->playlistList.count() == 1)
        {
            QString stripped = this->playlistList.takeFirst()->text(playlistColumn).toLower().remove(QRegExp("[^A-Za-z0-9]"));
            bool existsAlready = QFile("/home/user/MyDocs/.audiowiki/" +  stripped+".txt").exists();
            qDebug()<<this->playlistList.takeFirst()->text(playlistColumn)<<existsAlready;
            openPlaylist = false;
            network->retrieveArticle(this->playlistList.takeFirst()->text(playlistColumn), existsAlready);
        }
        else
        {
            QString stripped = this->playlistList.takeFirst()->text(playlistColumn).toLower().remove(QRegExp("[^A-Za-z0-9]"));
            openPlaylist = true;
            bool existsAlready = QFile("/home/user/MyDocs/.audiowiki/" +  stripped+".txt").exists();
            qDebug()<<this->playlistList.takeFirst()->text(playlistColumn)<<existsAlready;
            network->retrieveArticle(this->playlistList.takeFirst()->text(playlistColumn), existsAlready);
        }
    }
    //TODO playlistat ei toimi
}

void MainWindow::openArticleList(QList<QString> searchTitles)
{
    articleList->fillTable(searchTitles, this->searchWord);
    if (!articleList->isVisible())
    {
        articleList->show();
        ui->mainWindowButton->setDown(true);
    }
    message->hide();
}

void MainWindow::newSearch(QString keyword)
{
    this->searchWord = keyword;
    network->searchKeyWord(keyword);
}

void MainWindow::openArticleInPlayer(QString title, QString article)
{


        qDebug()<<"open"<<title;
         message->setLabelText("Processing " + title);
         player->openArticle(title, article, openPlaylist);
         ui->playerButton->setDown(true);
         ui->mainWindowButton->setDown(false);


         if (openPlaylist)
         {
             qDebug()<<openPlaylist;
             openPlaylist = false;
          //   player->setPlaylistFocus();
         }
         else
         {
             if(!player->isVisible())
                player->show();
         }





     //message->hide();
}

void MainWindow::addToPlaylist(QString playlistname, QString item)
{
    qDebug()<<playlistname<<item;
    message->setLabelText("Saving");
    articleList->hide();
   // message->setParent(articleList);
    message->show();
    network->retrieveArticle(item, false, this->toPlaylist);
    playlist->addToPlaylist(playlistname, item);
    network->fileSaved(item);

}

/*void MainWindow::updateProgressBar(qint64 bytesReceived, qint64 bytesTotal)
{/*
    this->message->setMinimum(0);
    this->message->setMaximum(bytesTotal);
    this->message->setValue(bytesReceived);
    qDebug()<<"min" << this->message->minimum();
    qDebug()<<" max" <<this->message->maximum();
    qDebug()<<"rec" << bytesReceived;
    qDebug()<<"tot" << bytesTotal;



}*/

void MainWindow::on_searchLineEdit_textChanged(const QString &arg1)
{

}

void MainWindow::on_searchLineEdit_returnPressed()
{
    if (this->ui->searchLineEdit->text().isEmpty())
    {
        #ifdef Q_WS_MAEMO5
        QMaemo5InformationBox::information(this, "Please enter search word first",
                                                    QMaemo5InformationBox::DefaultTimeout);
        #endif
    }
    else
    {
        message->setLabelText("Searching");
        message->show();
        network->searchKeyWord(this->ui->searchLineEdit->text());
        this->searchWord = this->ui->searchLineEdit->text();
    }
}

void MainWindow::audioCreated()
{
    if (!this->toPlaylist)
        message->hide();
    else
    {
        this->toPlaylist = false;
      //  qDebug()<<"c"<<item;
        message->hide();
        this->articleList->show();
    }
}

void MainWindow::articleSaved(QString title)
{
    if (this->toPlaylist)
    {
        QString stripped = title.toLower().remove(QRegExp("[^A-Za-z0-9]"));
        player->createAudioForPlaylist("/home/user/MyDocs/.audiowiki/" +  stripped+".txt");
    }
}
