#ifndef PLAYER_H
#define PLAYER_H

#include <QWidget>
#include <QListWidgetItem>
#include <linklist.h>
#include <audio.h>


namespace Ui {
    class Player;
}

class Player : public QWidget
{
    Q_OBJECT

public:
    explicit Player(QWidget *parent = 0);
    void openArticle(QString itemTitle, QString text, bool playlist = false);
    void clearCurrentArticles();
    void setPlaylistFocus();
    void createAudioForPlaylist(QString title);
    ~Player();

private slots:
    void clear();

    void linkListWidget_itemClicked(QListWidgetItem *item);

    void on_backwardButton_clicked();

    void on_forwardButton_clicked();

    void on_playListWidget_itemClicked(QListWidgetItem *item);

    void on_linksButton_clicked();

    void on_playPauseButton_clicked();

    void playingFinished();

    void wavCreated();

signals:
    void openArticleFromLink(QListWidgetItem *item);
    void audioCreated();
    void playListFileAdded();

private:
    Ui::Player *ui;
    bool reload;
    LinkList *linkWidget;
    QString path;
    bool playing;
    Audio *audio;
    bool articleLoaded;

};

#endif // PLAYER_H
