#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui/QMainWindow>
#include <articlelist.h>
#include <playlist.h>
#include <player.h>
#include <options.h>
#include <network.h>
#include <QProgressDialog>

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT
public:
    enum ScreenOrientation {
        ScreenOrientationLockPortrait,
        ScreenOrientationLockLandscape,
        ScreenOrientationAuto
    };

    explicit MainWindow(QWidget *parent = 0);
    virtual ~MainWindow();

    // Note that this will only have an effect on Symbian and Fremantle.
    void setOrientation(ScreenOrientation orientation);

    void showExpanded();

private slots:
    void on_searchButton_clicked();

    void on_mainWindowButton_clicked();

    void on_playlistsButton_clicked();

    void on_playerButton_clicked();

    void article_selected(QTableWidgetItem *item);

    void playlist_item_selected(QTreeWidgetItem* item, int column);

    void playlist_selected(QList<QTreeWidgetItem *> items, int column);

    void on_optionsButton_clicked();

    void addToPlaylistClicked();

    void openArticleList(QList<QString>);

    void newSearch(QString keyword);

    void openArticleInPlayer(QString title, QString article);

    void addToPlaylist(QString playlist, QString item);

    void openArticleFromLink(QListWidgetItem *item);

    void on_searchLineEdit_textChanged(const QString &arg1);

    void on_searchLineEdit_returnPressed();

    void removePlaylistsMode();

private:
    Ui::MainWindow *ui;
    ArticleList *articleList;
    Playlist *playlist;
    Player *player;
    Options *options;
    Network *network;
    QString searchWord;
    QProgressDialog *message;
};

#endif // MAINWINDOW_H
