#ifndef ADDTOPLAYLIST_H
#define ADDTOPLAYLIST_H

#include <QWidget>
#include <QSplashScreen>
#include <QListWidgetItem>

namespace Ui {
    class AddToPlaylist;
}

class AddToPlaylist : public QSplashScreen
{
    Q_OBJECT

public:
    explicit AddToPlaylist(QString articleToAdd, QWidget *parent = 0);
    void fillList(QStringList items);
    ~AddToPlaylist();

private slots:
    void on_okButton_clicked();

    void on_listWidget_itemClicked(QListWidgetItem *item);

    void on_cancelButton_clicked();

signals:
    void addToPlaylist(QString playlistName, QString item);

private:
    Ui::AddToPlaylist *ui;
    QString article;
};

#endif // ADDTOPLAYLIST_H
