#include "articlelist.h"
#include "ui_articlelist.h"
#include <QDebug>
#include <QSplashScreen>
#include <addtoplaylist.h>
#ifdef Q_WS_MAEMO5
#include <QtMaemo5/QMaemo5InformationBox>
#endif

ArticleList::ArticleList(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::ArticleList)
{
    ui->setupUi(this);
    ui->tableWidget->setColumnWidth(0, 430);
    for (int i = 0; i < ui->tableWidget->rowCount(); i++)
        ui->tableWidget->setRowHeight(i, 80);
}

ArticleList::~ArticleList()
{
    delete ui;
}

/*void ArticleList::on_articleListWidget_itemClicked(QListWidgetItem *item)
{
    this->articleSelected(item);
    this->hide();
}
*/
void ArticleList::on_tableWidget_cellClicked(int row, int column)
{
    if (column == 0)
    {
        this->articleSelected(ui->tableWidget->item(row, column));
        this->hide();
    }
    else
    {
        this->selectedArticle = ui->tableWidget->item(row, 0)->text();
        this->addToPlaylistClicked();
    }
}

void ArticleList::openSplashScreen(QStringList titles)
{
     //AddToPlaylist *addToPlaylist = new AddToPlaylist(this);
     //addToPlaylist->show();
    AddToPlaylist *addToPlaylist = new AddToPlaylist(selectedArticle, this);
    addToPlaylist->fillList(titles);
    addToPlaylist->show();
    connect(addToPlaylist, SIGNAL(addToPlaylist(QString,QString)), this, SLOT(addToPlaylist(QString,QString)));
}

void ArticleList::fillTable(QList<QString> searchTitles, QString keyword)
{

    this->ui->tableWidget->setRowCount(searchTitles.count());
    if (!searchTitles.isEmpty())
    {
        int i = 0;
        foreach (QString title, searchTitles)
        {
            QTableWidgetItem *newItem = new QTableWidgetItem(QIcon(":/images/Icon_player_small.png"), title);
            QTableWidgetItem *newItem2 = new QTableWidgetItem(QIcon(":/images/Icon_plus.png"), "");
            this->ui->tableWidget->setItem(i,0, newItem);
            this->ui->tableWidget->setItem(i,1, newItem2);
            this->ui->tableWidget->setRowHeight(i, 80);
            i++;
        }
        this->ui->searchLabel->setText("Search results for \""+keyword+"\"");
    }
    else
        this->ui->searchLabel->setText("No results for \""+keyword+"\"");
}

void ArticleList::on_searchButton_clicked()
{
    if (this->ui->searchLineEdit->text().isEmpty())
    {
        #ifdef Q_WS_MAEMO5
        QMaemo5InformationBox::information(this, "Please enter search word first",
                                                    QMaemo5InformationBox::DefaultTimeout);
        #endif
    }
    else
    {
        this->ui->tableWidget->clear();
        this->newSearch(this->ui->searchLineEdit->text());
    }
}

void ArticleList::addToPlaylist(QString playlist, QString item)
{
    this->articleToPlaylist(playlist, item);
}
