#include "addtoplaylist.h"
#include "ui_addtoplaylist.h"

AddToPlaylist::AddToPlaylist(QString articleToAdd, QWidget *parent) :
    ui(new Ui::AddToPlaylist)
{
    ui->setupUi(this);
    article = articleToAdd;

    //ui->listWidget->addItems(titles);
}

AddToPlaylist::~AddToPlaylist()
{
    delete ui;
}

void AddToPlaylist::on_okButton_clicked()
{
    this->addToPlaylist(this->ui->newLineEdit->text(), article);
    this->close();
}

void AddToPlaylist::on_listWidget_itemClicked(QListWidgetItem *item)
{
    this->addToPlaylist(item->text(), article);
    this->close();
}

void AddToPlaylist::on_cancelButton_clicked()
{
    this->close();
}

void AddToPlaylist::fillList(QStringList items)
{
    this->ui->listWidget->addItems(items);
}
