from Box2D import *
import pygame, math, random
from object import Object
from bullet import Bullet
from player import Player
from asteroid import Asteroid

pygame.init()

CREATE_ASTEROID = 30
REMOVE_BULLET = 31
pygame.time.set_timer(CREATE_ASTEROID, 1000)
pygame.time.set_timer(REMOVE_BULLET, 3000)

screen = pygame.display.set_mode((800,440))

background = pygame.Surface(screen.get_size())
background = background.convert()
background.fill((255,255,255))
screen.blit(background, (0,0))
pygame.display.flip()

def acc_read():
    try:
        f = open("/sys/class/i2c-adapter/i2c-3/3-001d/coord", 'r' )
        coords = [int(w) for w in f.readline().split()]
        f.close()
    except Exception:
        coords = [0.5,0.5,0.5]
    return coords


worldAABB=b2AABB()
#worldAABB.lowerBound.Set(0, 0)
worldAABB.lowerBound.Set(-8, -4.8)
worldAABB.upperBound.Set(8, 4.8)
 
gravity = b2Vec2(0, 0)
 
doSleep = True
 
world = b2World(worldAABB, gravity, doSleep)
#print dir(world)


#groundBodyDef = b2BodyDef()
#groundBodyDef.position.Set(0, -10)
 
# Call the body factory which allocates memory for the ground body
# from a pool and creates the ground box shape (also from a pool).
# The body is also added to the world.
#groundBody = world.CreateBody(groundBodyDef)
 
# Define the ground box shape.
#groundShapeDef = b2PolygonDef()
 
# The extents are the half-widths of the box.
#groundShapeDef.SetAsBox(4, 1)
 
# Add the ground shape to the ground body.
#groundBody.CreateShape(groundShapeDef)
 
# Define the dynamic body. We set its position and call the body factory.

clock = pygame.time.Clock()
angle = 0
player = Player(world)
#bullet = Bullet(100,120,-1,-1,world)
#bullet.body.linearVelocity = (1,1)
#print dir(bullet.body)

bullets = []
asteroids = []
surf_x = 400
surf_y = 200

timeStep = 1.0/60.0

surf_copy = pygame.Surface((50,50))
#surf_copy.fill((255,255,255))

print dir(player.body)
font = pygame.font.Font(None,25)

#ast = Asteroid(0,world)


#b = b2ContactListener()
#world.SetContactListener(b)
#b.Add(player.body)
#print dir(b)



while True:
    #print len(asteroids)
    clock.tick(60)
    acc = acc_read()
    vx = acc[0]
    vy = acc[1]
    event = pygame.event.poll()
    if event.type == CREATE_ASTEROID:
        asteroids.append(Asteroid(random.random()*3,world))

    #if event.type == REMOVE_BULLET:
    #    if len(bullets) > 0:
    #        bullets.pop()

    if event.type == pygame.KEYDOWN or event.type == pygame.MOUSEBUTTONDOWN:
        if len(bullets) > 50:
            #bullets = []
            del bullets
            bullets = []
        bullet = Bullet(420, 240, vx/50.0, vy/50.0,world)
        bullets.append(bullet)

    #if event.type == pygame.MOUSEBUTTONDOWN:
    #    ast = Asteroid(1,world)
    #    asteroids.append(ast)

    for a in asteroids:
        a.update()
        background.blit(a.surf, (a.x,a.y))
    #sak = font.render("%i" % (pygame.time.get_ticks()/1000.0), True, (0,0,0))
    sak = font.render("%i" % (len(bullets)), True, (0,0,0))
    background.blit(sak, (30,90))


    for b in bullets:
        b.update()
        background.blit(b.surf, (b.x,b.y))   

    #background.blit(ast.surf, (ast.x,ast.y))

    x_sak = font.render("%i" % vx, True, (0,0,0))
    y_sak = font.render("%i" % vy, True, (0,0,0))

    background.blit(x_sak, (30,50))
    background.blit(y_sak, (30,70))

    
    #player.update()
    #ast.update()
    #ast.move()
    screen.blit(background, (0,0))
    background.fill((255,255,255))
    surf_copy = pygame.transform.rotate(player.surf, math.degrees(angle))
    #player.update()
    vel_iters, pos_iters = 10, 8
    world.Step(timeStep, vel_iters, pos_iters)
     
    background.blit(surf_copy, (player.x, player.y))
    if vy is not 0:
        #print x/float(y)
        try:
            if vx > 0 and vy > 0:
                angle = math.atan(vx/float(vy))+math.pi
            elif vx < 0 and vy > 0:
                angle = math.atan(vx/float(vy))+math.pi
            else:
                angle = math.atan(vx/float(vy))
        except ValueError:
            angle = 0
    pygame.display.flip()
