uniform sampler2D myTex;
uniform sampler2D depthTex;
uniform mediump vec3 lightDir;
uniform highp float id;

varying mediump vec3 normal;
varying highp vec2 texCoord;
varying highp vec4 shadowCoord;

const highp vec4 unpackFactors = vec4(1.0/(256.0 * 256.0 * 256.0), 1.0/(256.0 * 256.0), 1.0/256.0, 1.0);

void main() {
	highp float comp = (shadowCoord.z / shadowCoord.w) - 0.003;
	highp vec4 col = unpackFactors*texture2DProj(depthTex, shadowCoord);
	highp float depth = col.r+col.g+col.b+col.a;

	lowp float val = comp <= depth ? 1.0 : 0.4;
	
	mediump float lightIntensity = max(dot(normalize(normal), lightDir), 0.0); // phong light
	mediump vec3 colour = texture2D(myTex, texCoord).rgb * max(lightIntensity, 0.2) * val;
	
    gl_FragColor = vec4(colour, id);
}
