/*
 * VideoQuad.cpp
 *
 *  Created on: 22.10.2009
 *      Author: pavel
 */

#ifdef NO_ES
	#include <GL/glew.h>
	#include <GL/gl.h>
#else
	#include <GLES2/gl2.h>
#endif

#include "ShadowQuad.h"

void ShadowQuad::setup() {
	const float size = 8;
	const float quad[] = {-size, 0,-size,  // Pos
						 0, 1, 0,  // Normal
						 0, 1,     // UV
						-size, 0, size,
						 0, 1, 0,
						 0, 0,
						 size, 0,-size,
						 0, 1, 0,
						 1, 1,
						 size, 0, size,
						 0, 1, 0,
						 1, 0};

    glGenBuffers(1, &vbo);
    glBindBuffer(GL_ARRAY_BUFFER, vbo);
    glBufferData(GL_ARRAY_BUFFER, 8*4*sizeof(float), quad, GL_STATIC_DRAW);
    glBindBuffer(GL_ARRAY_BUFFER, 0); // unbind
}

void ShadowQuad::render(QGLShaderProgram& sp) {
    glBindBuffer(GL_ARRAY_BUFFER, vbo);

    sp.enableAttributeArray("vertex");
    sp.setAttributeArray("vertex", 0, 3, 8*sizeof(float));

    glDrawArrays(GL_TRIANGLE_STRIP, 0, 4);

    glBindBuffer(GL_ARRAY_BUFFER, 0); // unbind
}

void ShadowQuad::cleanup() {
    glDeleteBuffers(1, &vbo);
}
