/*
 * Quad.h
 *
 *  Created on: 22.10.2009
 *      Author: pavel
 */

#pragma once

#include <QGLShaderProgram>
#include <QMatrix4x4>
#include <QImage>

class CanvasPlane {
public:
    CanvasPlane();
	void setup(QColor& bg);
	void render(QGLShaderProgram& sp, QMatrix4x4& matPMV, bool editing);
	void cleanup();
	void drawAt(float x, float y);
	static void setMatFill();
	QMatrix4x4 matMV;
	static QMatrix4x4 matFill;
	QImage img;
	bool newStroke;
private:
	static const unsigned int size = 128;
    unsigned int lastX;
    unsigned int lastY;
	unsigned int vbo;
	unsigned int texture;
};

