#!/usr/bin/perl
# Read include file, to generate pointers

$file = @ARGV[0];

if ( ! defined(open(FILE, $file)) ) {
	warn "Couldn't open $file: $!\n";
	exit;
}

print "/* Generated by dyngl_h.pl from $file */\n\n";

$linecount=0;
while ($line = <FILE>) {
	if ($line =~ /^GLAPI/ ) {
		# Read line starting with GLAPI, ending with );
		while (! ($line =~ /\);/)) {
			chomp($ligne);
			$line .= " " . <FILE>;
		}
		$line =~ s/\t//g;
		$line =~ s/\n//g;
		$line =~ s/ +/ /g;

		# Add missing parameters (for glext.h)
		$letter = 'a';
		while ($line =~ /[,\( ] *GL\w+\** *\**,/ ) {
			$line =~ s/([,\( ] *GL\w+\** *\**),/$1 $letter,/;
			$letter++;
		}
		while ($line =~ /[,\( ] *GL\w+\** *\**\)/ ) {
			$line =~ s/([,\( ] *GL\w+\** *\**)\)/$1 $letter\)/;
			$letter++;
		}
		while ($line =~ /[,\( ] *GL\w+\** *const *\*,/ ) {
			$line =~ s/([,\( ] *GL\w+\** *const *\*),/$1 $letter,/;
			$letter++;
		}

		if ($line =~ /^GLAPI *(\w+).* (GL)*APIENTRY *gl(\w+) *(\(.*)/ ) {
			$return_type = $1 ;
			$function_name = $3 ;
			$parameters = $4;
		} else {
			$return_type = "" ;
			$function_name = "" ;
			$parameters = "";
		}

		# Remove start of line
		$line =~ s/^GLAPI.*(GL)*APIENTRY *gl// ;
		$line =~ s/^ *// ;

		chomp($line);

		print "\t$return_type (STDCALL *$function_name)$parameters\n";

		$linecount++;
	}
}
close(FILE);
print "/* Functions generated: $linecount */\n";
