from xml.etree.ElementTree import ElementTree
from glob import glob

tree = ElementTree()
tree.parse('/etc/hildon-application-manager/catalogues')

class Package(object):
    def __init__(self, section=None, installed_size=None, version=None):
        self.section = section
        self.installed_size = installed_size
        self.version = version

class Catalogues(object):
    def __init__(self):
        self._aliases = []
        self.fillCatalogues()

    def fillCatalogues(self):
        CATALOGUES_PATH = '/etc/hildon-application-manager/catalogues'
        tree = ElementTree()
        tree.parse(CATALOGUES_PATH)
        catalogues = {}

        uri = None
        alias = ''
        packages = {}

        for filename in glob('/var/lib/apt/lists/*Packages'):
            try:
                getattr(self, alias)
            except AttributeError:
                packages = {}

            for catalogue in tree.getiterator('catalogue'):
                if catalogue.find('uri') is not None:
                    uri = catalogue.find('uri').text.split('http://')[1].replace('/', '_')

                if uri and uri in filename and uri != 'repository.maemo.org':
                    alias = catalogue.find('name').text
                elif 'ovi' in filename:
                    alias = 'Ovi'
                elif 'ssu_002' in filename:
                    alias = 'Nokia System Software Updates'
                elif 'ssu_apps' in filename:
                    alias = 'Nokia Applications'
                elif 'extras_dist' in filename:
                    alias = 'Extras'

            for line in open(filename).readlines():
                if 'Package: ' in line:
                    name = line.split('Package: ')[1].strip()
                    packages[name] = Package()
                elif 'Section: user/' in line:
                    packages[name].section = line.split('Section: user/')[1].strip()
                elif 'Installed-Size: ' in line:
                    packages[name].installed_size = line.split('Installed-Size: ')[1].strip()
                elif 'Version: ' in line:
                    packages[name].version = line.split('Version: ')[1].strip()

            setattr(self, alias, packages)
