/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.perforce;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.tools.ant.taskdefs.optional.perforce.P4Handler;

public class P4OutputStream
extends OutputStream {
    private P4Handler handler;
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private boolean skip = false;

    public P4OutputStream(P4Handler handler) {
        this.handler = handler;
    }

    public void write(int cc) throws IOException {
        byte c = (byte)cc;
        if (c == 10 || c == 13) {
            if (!this.skip) {
                this.processBuffer();
            }
        } else {
            this.buffer.write(cc);
        }
        this.skip = c == 13;
    }

    protected void processBuffer() {
        this.handler.process(this.buffer.toString());
        this.buffer.reset();
    }

    public void close() throws IOException {
        if (this.buffer.size() > 0) {
            this.processBuffer();
        }
        super.close();
    }
}

