# -*- coding: utf-8 -*-
#CPE 1704 TKS
"""
Standard Manupilation modules that are not directly UI based.
"""
import copy
import os

from PIL import Image
from PyQt4.QtCore import QRect


class ParamValues():
    def __init__(self):
        self.valR = 0
        self.valB = 0
        self.valG = 0
        self.valSa = 0
        self.valSh =0
        self.valBr = 0
        self.valCo = 0
        self.valHi =5
        self.valMi =5
        self.valSw =5
        self.valRot = 0
        self.GPSLat =0
        self.GPSLatRef =1
        self.GPSLon=0
        self.GPSLonRef =1
        self.flipBottom = False
        self.flipRight = False
        self.flipAng = 0
        self.valCropTop=0
        self.valCropBottom=0
        self.valCropLeft=0
        self.valCropRight=0
        self.valOrient = 0
        self.valBW = "L"
        self.wMaximized = True
        self.lockUpdating = False
        self.displayUpdating = False
        self.DefaultCurImageDir =os.getcwd()+"/ui/resources/"
        self.DefaultCurImageName ="Ansel-A-Default.jpg"
        self.curImageLoc =self.DefaultCurImageDir+self.DefaultCurImageName
        self.plotIm =""
        
        #Current Image
        self.current = ImageInfo()
        
        self.plistIm = ""
        self.valCurTab=0
        self.ApplyVisible = True #Leave true so Init_ can hide
        self.EXIFLoaded = False
        
        self.SearchMMC = False
        self.SearchOn = True
        self.SomethingLoad = False
        self.imageDir = "/home/user/MyDocs/DCIM/"
        self.imageDirMMC = "/media/mmc1/DCIM/"
        self.thumbsDir = "/home/user/apps/anselA/.thumbs/"
        self.cancelPlistToggle = False
        self.thumbsCount = 0
        self.undoCount = 0
        self.undoSelected = 0
        self.undoList_IM = list() 
        
    def SetCurrentTab(self, Value):
        self.valCurTab=Value
        
    def GetCurrentTab(self, Value):
        return self.valCurTab
    
    def UndoImage_Clear(self):
        del self.undoList_IM
        self.undoList_IM = list() 
        self.undoCount =0
        
    def UndoImage_Push(self):
        #print "UndoImage_Push"
        last = copy.copy(self.current)
        #last = copy.deepcopy(self.current)
        self.undoList_IM.append(last)
        self.undoCount +=1
    
    def UndoImage_Pop(self):
        if (self.undoCount <> 0):
            self.current=copy.copy(self.undoList_IM.pop())
            self.undoCount -=1
    
    def UndoImage_Set(self):
        ##count should be less than one but you need to pop off.
        #reload preforms a push back.
        for i in range(int(self.undoSelected),  self.undoCount):
            self.UndoImage_Pop()
        
class ImageInfo():
    sizeDisplayThumb_X = 0
    sizeDisplayThumb_Y = 0
    sizeDisplayThumb_H = 0
    sizeDisplayThumb_W = 0
    sizeDisplayImage_X = 0
    sizeDisplayImage_Y = 0
    sizeDisplayImage_H = 0
    sizeDisplayImage_W = 0
    image=Image
    thumb=Image

    
    def setImageDisplaySize(self, DisplayPosX=0, DisplayPosY=0,  DisplayWidth=0,  DisplayHeight=0):
        self.sizeDisplayImage_H = DisplayHeight
        self.sizeDisplayImage_W = DisplayWidth
        self.sizeDisplayImage_X = DisplayPosX
        self.sizeDisplayImage_Y = DisplayPosY
        
    def setThumbDisplaySize(self, DisplayPosX=0, DisplayPosY=0,  DisplayWidth=0,  DisplayHeight=0):
        self.sizeDisplayThumb_H = DisplayHeight
        self.sizeDisplayThumb_W = DisplayWidth
        self.sizeDisplayThumb_X = DisplayPosX
        self.sizeDisplayThumb_Y = DisplayPosY
    
    def getThumbDisplaySize(self):
        return QRect(self.sizeDisplayThumb_X , self.sizeDisplayThumb_Y, self.sizeDisplayThumb_W, self.sizeDisplayThumb_H)
        
    def getImageDisplaySize(self):
        return QRect(self.sizeDisplayImage_X , self.sizeDisplayImage_Y, self.sizeDisplayImage_W, self.sizeDisplayImage_H)
        
    def setImage(self, image):
       thisImage = image
    
    def setThumb(self, image):
        thisThumb = image
    

