# -*- coding: utf-8 -*-
#CPE 1704 TKS
"""
Standard Manupilation modules that are not directly UI based.
"""
import math
from PIL import Image
from core.core import *
from filters.display import *
from PIL import ImageDraw
from PIL import ImageEnhance
from PyQt4 import QtCore as QtCore
from PyQt4 import QtGui as QtGui 
from filters.toolbox import pil2qpixmap
from PyQt4.QtCore import pyqtSignature

#     out = im.transpose(Image.FLIP_LEFT_RIGHT)
#     out = im.transpose(Image.FLIP_TOP_BOTTOM)
#     out = im.transpose(Image.ROTATE_90)
#     out = im.transpose(Image.ROTATE_180)
#     out = im.transpose(Image.ROTATE_270)

### GUI Function Calls 
def rotateImage(self, image, ExifRot=0):
    if (ExifRot != 0):
        if (ExifRot == 90):
            return image.rotate(-90)
        elif (ExifRot == 180):
            return image.rotate(180)
        elif (ExifRot == 270):  
            return image.rotate(-270)
    else:
        return image


### NON-GUI Function Calls 

def RotateCalc(self, rotation, im):
    w, h = im.size
    theta =math.radians(rotation)

    botOps = round(abs(h * math.sin(theta))/2)
    botAdj = round(abs(h * math.cos(theta))/2)

    topOps = round(abs(w * math.sin(theta))/2)
    topAdj = round(abs(w * math.cos(theta))/2)

    theta = theta + math.pi/4
    if theta >= 6.28:
        theta = theta - 6.28
    pi2 = math.pi/2

    if( theta >= 0.0 and theta < pi2 ): #0 - 1.57 
        return([botOps,botOps, int(w-botOps),  int(h-botOps)]) 
    elif( theta >= pi2 and theta < math.pi): # 1.57 - 3.14
        return([botOps, botAdj, int(w-botOps),  int(h-botAdj)]) 
    elif( theta >= math.pi and theta < (math.pi + pi2) ): # 3.14 - 4.71
        return([botOps, botOps, int(w-botOps),  int(h-botOps)]) 
    elif( theta >= (math.pi + pi2)):  # 4.71 - 6.28 ok 
        return([botOps, botAdj, int(w-botOps),  int(h-botAdj)]) 


@pyqtSignature("int")
def RotateThumb(self, rotation):
    showUpdateLabel(self, True,  True)
    im=self.core.current.thumb
    
    im = im.rotate(rotation,  resample=Image.BICUBIC,  expand=0)
    draw = ImageDraw.Draw(im)
    draw.rectangle(RotateCalc(self, rotation, im))
    del draw
    
    self.photo_Thumb.setPixmap(pil2qpixmap(im))
    showUpdateLabel(self, False,  True)
    

@pyqtSignature("int")    
def RotateApply(self, rotation):
    if  (self.core.lockUpdating == False):
        showUpdateLabel(self, True,  False)
        im=self.core.current.image
        
        if self.core.flipRight:
            self.core.current.image = im.transpose(Image.FLIP_LEFT_RIGHT) 
        elif self.core.flipBottom:
            self.core.current.image = im.transpose(Image.FLIP_TOP_BOTTOM)  
        elif self.core.flipAng==90:
            self.core.current.image = im.transpose(Image.ROTATE_90) 
        elif  self.core.flipAng==180:
            self.core.current.image = im.transpose(Image.ROTATE_180) 
        elif  self.core.flipAng==270:    
            self.core.current.image = im.transpose(Image.ROTATE_270) 
        else:    
            im = im.rotate(rotation,  resample=Image.BICUBIC,  expand=0)
            w1, h1, w2, h2 = RotateCalc(self,  rotation, im)
        
            self.core.current.image = im.crop((w1, h1, w2, h2))

        showUpdateLabel(self, False,  False)
        self.core.lockUpdating = False


@pyqtSignature("int,Bool,Bool")
def FlipThumb(self):
    showUpdateLabel(self, True,  True)
    im=self.core.current.thumb
    
    if self.core.flipRight:
        im = im.transpose(Image.FLIP_LEFT_RIGHT) 
    if self.core.flipBottom:
        im = im.transpose(Image.FLIP_TOP_BOTTOM) 
        
    if self.core.flipAng==90:
        im = im.transpose(Image.ROTATE_90) 
    elif  self.core.flipAng==180:
        im = im.transpose(Image.ROTATE_90) 
        im = im.transpose(Image.ROTATE_90) 
    elif  self.core.flipAng==270:    
        im = im.transpose(Image.ROTATE_270) 
        
    self.photo_Thumb.setPixmap(pil2qpixmap(im))
    showUpdateLabel(self, False,  True)
    
    
    
#    ImageOps.fit(image, size, method, bleed, centering) => image
#
#Returns a sized and cropped version of the image, cropped to the requested aspect ratio and size. The size argument is the requested output size in pixels, given as a (width, height) tuple.
#
#The method argument is what resampling method to use. The default is Image.NEAREST (nearest neighbour).
#
#The bleed argument allows you to remove a border around the outside the image (from all four edges). The value is a decimal percentage (use 0.01 for one percent). The default value is 0 (no border).
#
#The centering argument is used to control the cropping position. (0.5, 0.5) is center cropping (i.e. if cropping the width, take 50% off of the left side (and therefore 50% off the right side), and same with top/bottom).
#
#(0.0, 0.0) will crop from the top left corner (i.e. if cropping the width, take all of the crop off of the right side, and if cropping the height, take all of it off the bottom).
#
#(1.0, 0.0) will crop from the bottom left corner, etc. (i.e. if cropping the width, take all of the crop off the left side, and if cropping the height take none from the top (and therefore all off the bottom)).
#
#The fit function was contributed by Kevin Cazabon.
#flip
#
#ImageOps.flip(image) => image
