
# -*- coding: utf-8 -*-
#CPE 1704 TKS
"""
Standard Manupilation modules that are not directly UI based.
"""
import os

from PIL import Image
from PyQt4 import QtCore as QtCore, QtGui as QtGui
from filters.imageExif import *
from files import *
from buttons import *
from filters.toolbox import *
from filters.display import *

@pyqtSignature("Bool")
def populatePhotoList(self, ForceRefresh=False):
    if self.core.thumbsCount == 0:
        self.core.thumbsCount =21
        
    self.frameCancelPListLoad.setGeometry(QtCore.QRect(0, 0, 800, 480))
    self.core.populatePhotoList = True
    self.btnEdit.setVisible(True)
    self.btnPlistZoom.setVisible

    self.listPhotos.clear()
    
    self.repaint()
    self.tabPhoto.repaint()
    Tsize = (100, 100)
    i=0
    self.labCancel.setText("Loading Photos...")
    self.labCancel.repaint()
    if not os.path.exists (self.core.thumbsDir):
        os.makedirs (self.core.thumbsDir)
    
    files =[]
    try:
        
        for file in os.listdir(self.core.imageDir):
            files.append(file)
            
        for file in reversed(files):
            if self.core.populatePhotoList ==True:
                
                NULL,  NULL,  fileExtension =StripFilename(self, self.core.thumbsDir+file)
        
                if ((not os.path.exists(self.core.thumbsDir+file)) or ForceRefresh):
                    try:
                        im = Image.open(self.core.imageDir+file)
                        im.thumbnail((Tsize), Image.NEAREST)
                        #os.remove(self.core.thumbsDir+file)
                        im.save(self.core.thumbsDir+file)
                    except:
                        continue
                
                
                try:
                    ## Get the PListobject with predefined sizes
                    photoItem = PlistWidgetItem()
                    im=Image.open(self.core.thumbsDir+file,  "r" )
                    
                    icon =QtGui.QIcon(self.core.thumbsDir+file)
                    photoItem.setIcon(icon)
                    photoItem.setImageType(fileExtension)
                    photoItem.setText(file.replace(photoItem.getImageType() , ""))
                    photoItem.setIconSize(im.size[0], im.size[1])
                    
                    photoItem.setImageLocation(self.core.imageDir+file)
                    
                    h, w = convertImSize(self.core, im.size[0], im.size[1],  250,  150)
                    ##This needs to me the x.y location bplus half of the thumbnailmbnail size. so 40+(150/2)
                    ##photoListZoom size is set here.
                    photoItem.setIconZoomSize(self.ScaleLabel(195,  400,  w,  h)) 
             
                    self.listPhotos.addItem(photoItem)
                    self.listPhotos.item(i).setIcon(icon)
                    
                    ##  if i % 5 == 0:
                    self.labCancel.setText("Loading Photos..."+str(i))
                    self.labCancel.repaint()
                except:
                        continue
                        
                i+=1
                if i == self.core.thumbsCount:
                    self.listPhotos.addItem("Load More...")
                    break
    except:
        print "Error: postShow"
        reply = QtGui.QMessageBox.question(self, 'Message',"Could not find any photos. Please take a photo or change the search directory in settings.", QtGui.QMessageBox.Ok)
        self.btnEdit.setVisible(False)
        self.btnPlistZoom.setVisible(False)
                
    self.listPhotos.repaint()
    self.frameCancelPListLoad.setGeometry(QtCore.QRect(0, 0, 0, 0))


def LoadCurImageFromPhotoBrowser(self):
    SlidersReset(self)
    ShowApply(self, False)
    self.photo_Thumb.setPixmap(self.photoListZoom.pixmap())
    self.photo_Thumb.setGeometry(self.photoListZoom.geometry())
    ToggleThumbWait(self, True)
    FullScreenToggle(self, False)
    self.repaint()
    FileImageOpen(self,  self.core.plistIm)
    self.core.SetCurrentTab(2)
    self.tabStrip.setCurrentIndex(2)
    PhotTabs_Show(self)
    ToggleThumbWait(self, False)
     


class PtreeWidgetItem(QtGui.QTreeWidgetItem):
    iconSize =(0, 0)
    
class PlistWidgetItem(QtGui.QListWidgetItem):
    iconSize =(0, 0)
    iconZoomSize =(0, 0, 0, 0)
    thumbLocation= ""
    imageLocation =""
    imageType=""
    rotation =0
    
    def getRotation(self):
        GetExifRotation(imageLocation)

    def setIconSize(self,  Height=0,  Width=0):
        self.iconSize =(Height,  Width)

    def getIconSize(self):
        return self.iconSize

    def setIconZoomSize(self, value):
        self.iconZoomSize = value
        
        
    def getIconZoomSize(self):
        return self.iconZoomSize
        
    def getImageLocation(self):
        return self.imageLocation

    def setImageLocation(self, value):
        self.imageLocation = value

    def getThumbLocation(self):
        return self.thumbLocation

    def setThumbLocation(self, value):
        self.thumbLocation = value
        
    def getImageType(self):
        return self.imageType

    def setImageType(self, value):
        self.imageType = value
    
    
    class PhotoView(QtGui.QLabel):
        def __init__(self, parent=None):
            QtGui.QLabel.__init__(self, parent)
            self.setText('Lorem Ipsum')

        def mouseReleaseEvent(self, event):
            print 'Label clicked!'
