# -*- coding: utf-8 -*-
#CPE 1704 TKS
"""
Module implementing MainWindow GUI, anselA
"""
import glob
import math
import operator
import os
import sys
import webbrowser
from subprocess import call

from PIL import Image
from PIL import ImageDraw
from PIL import ImageEnhance
from PyQt4 import QtCore as QtCore
from PyQt4 import QtGui as QtGui 
from PyQt4.QtCore import pyqtSignature
from PyQt4.QtGui import QMainWindow

import imports.EXIF
from core.browser import *
from core.core import *
from core.buttons import *
from core.files import *
from filters.bw import *
from filters.colors import *
from filters.histogram import *
from filters.imageExif import *
from filters.levels import *
from filters.rotate import *
from filters.toolbox import *
from filters.simple import *
from ui.Ui_mainWindow import Ui_MainWindow
from filters.toolbox import pil2qpixmap


class MainWindow(QMainWindow, Ui_MainWindow,  ParamValues):
    """
    Main Window Class for AnselA
    """
    core=ParamValues()

        
    def __init__(self, parent = None):
        """
        Constructor
        """
        try:
            QMainWindow.__init__(self, parent)
            self.setupUi(self)
            
            FileImageOpen(self,  self.core.curImageLoc)
            self.ShowApply(False)
            self.postSetup()
            
            
            FileImageRefresh(self)
            self.ShowApply(False)
            self.core.plotIm=Image.open("/opt/anselA/ui/resources/graph.png") 
        except:
            return

    def postSetup(self):
        self.tabStrip.setCurrentIndex(0)
        self.photo.setMouseTracking= True
        populatePhotoList(self)
        self.listPhotositemLoad(self.listPhotos.item(0))

    @pyqtSignature("")
    def on_btnExitGo_released(self):
        sys.exit()
        
        
    @pyqtSignature("Bool")
    def ShowApply(self, Show):
        if self.core.ApplyVisible <> Show:
            self.core.ApplyVisible = Show
            self.btnApplyUndo.setText(":"+str(self.core.undoCount))
            if Show:
                self.btnApply.setVisible(True)
                self.btnApplyUndo.setVisible(True)
            else:
                self.btnApply.setVisible(False)
                self.btnApplyUndo.setVisible(False)
        
    @pyqtSignature("Bool, Image")
    def showUpdateLabel(self, show,  thumb):
        self.ShowApply(True)
        self.lockUpdating = show
        if (thumb == True):
            if (show == True):
                self.labWaitThumb.setGeometry(-30, -30, 380, 450)
            else:
                self.labWaitThumb.setGeometry(QtCore.QRect(0, 0, 0, 0))
        else:
            if (show == True):
                self.FullScreenToggle(True)
                self.labWait.setGeometry(QtCore.QRect(0, 0, 797, 433))
            else:
                self.FullScreenToggle(False)
                self.labWait.setGeometry(QtCore.QRect(0, 0, 0, 433))
        self.labWait.repaint()
        self.repaint()

    
    @pyqtSignature("")
    def on_btn_Grey_released(self):
        self.core.valBW = "L"
        Convert_BW(self, self.core.current.thumb,  self.core.valBW,  False)
    
    @pyqtSignature("")
    def on_btn_Red_released(self):
        self.core.valBW = "R"
        Convert_BW(self, self.core.current.thumb,  self.core.valBW,  False)
    
    @pyqtSignature("")
    def on_btn_Green_released(self):
        self.core.valBW = "G"
        Convert_BW(self, self.core.current.thumb,  self.core.valBW,  False)
    
    @pyqtSignature("")
    def on_btn_Blue_released(self):
        self.core.valBW = "B"
        Convert_BW(self, self.core.current.thumb,  self.core.valBW,  False)
 
    @pyqtSignature("")
    def on_btn_Yellow_released(self):
        self.core.valBW = "Y"
        Convert_BW(self, self.core.current.thumb,  self.core.valBW,  False)
    
    @pyqtSignature("")
    def on_btn_Cyan_released(self):
        self.core.valBW = "C"
        Convert_BW(self, self.core.current.thumb,  self.core.valBW,  False)
    
    @pyqtSignature("")
    def on_btn_Magenta_released(self):
        self.core.valBW = "M"
        Convert_BW(self, self.core.current.thumb,  self.core.valBW,  False)

    @pyqtSignature("int")
    def on_cSlide_B_valueChanged(self, value):
        if (self.core.valB <> value):
            self.core.valB = cSlide_SetValue(self, value,  self.core.valB,  self.lcdB, self.cSlide_B)
        
    def on_btnSlide_B_up_pressed(self):
        self.core.valB = cSlide_ShiftValue(self,  1,  self.core.valB,  self.lcdB, self.cSlide_B)
        
    def on_btnSlide_B_dn_pressed(self):
        self.core.valB = cSlide_ShiftValue(self, -1,  self.core.valB,  self.lcdB, self.cSlide_B)

    @pyqtSignature("int")
    def on_cSlide_R_valueChanged(self, value):
        """
        Set Red Value
        """
        if (self.core.valR <> value):
            self.core.valR = cSlide_SetValue(self, value,  self.core.valR,  self.lcdR, self.cSlide_R)
        
    def on_btnSlide_R_dn_pressed(self):
        self.core.valR = cSlide_ShiftValue(self,  -1,  self.core.valR,  self.lcdR, self.cSlide_R)
        
    def on_btnSlide_R_up_pressed(self):
        self.core.valR = cSlide_ShiftValue(self, 1,  self.core.valR,  self.lcdR, self.cSlide_R)       
    
    @pyqtSignature("int")
    def on_cSlide_G_valueChanged(self, value):
        """
        Set Green Value
        """
        if (self.core.valG <> value):
            self.core.valG = cSlide_SetValue(self, value,  self.core.valG,  self.lcdG, self.cSlide_G)
        
    def on_btnSlide_G_up_pressed(self):
        self.core.valG = cSlide_ShiftValue(self,  1,  self.core.valG,  self.lcdG, self.cSlide_G)
        
    def on_btnSlide_G_dn_pressed(self):
        self.core.valG = cSlide_ShiftValue(self, -1,  self.core.valG,  self.lcdG, self.cSlide_G)
    

    @pyqtSignature("int")
    def on_cSlide_Hi_valueChanged(self, value):
        self.core.valHi = value
        self.lcdHi.setText(str(self.core.valHi))
    
    @pyqtSignature("int")
    def on_cSlide_Mi_valueChanged(self, value):
        self.core.valMi = value
        self.lcdMi.setText(str(self.core.valMi))
    
    @pyqtSignature("int")
    def on_cSlide_Sw_valueChanged(self, value):
        self.core.valSw = value
        self.lcdSw.setText(str(self.core.valSw))
        
    @pyqtSignature("int")
    def on_cSlide_Sh_valueChanged(self, value):
        self.core.valSh = value
        self.lcdSh.setText(str(self.core.valSh))
        Simple_Adjustments(self,self.core.current.thumb,  "Sh",  False)
    
    @pyqtSignature("int")
    def on_cSlide_Sa_valueChanged(self, value):
        self.core.valSa = value
        self.lcdSa.setText(str(self.core.valSa))
        Simple_Adjustments(self,self.core.current.thumb,  "Sa",  False)
    
    @pyqtSignature("int")
    def on_cSlide_Co_valueChanged(self, value):
        self.core.valCo = value
        self.lcdCo.setText(str(self.core.valCo))
        Simple_Adjustments(self,self.core.current.thumb,  "Co",  False)
    
    @pyqtSignature("int")
    def on_cSlide_Br_valueChanged(self, value):
        self.core.valBr = value
        self.lcdBr.setText(str(self.core.valBr))
        Simple_Adjustments(self,self.core.current.thumb,  "Br",  False)
        
    @pyqtSignature("int")
    def on_dial_valueChanged(self, value):
        if  (self.core.lockUpdating == False):
            self.core.valRot = value
            self.lcdRot_1.setText(str(self.core.valRot))
            RotateThumb(self,  value)
           
    @pyqtSignature("")
    def on_btnExitCancel_released(self):
        self.tabStrip.setCurrentIndex(self.core.valCurTab)
        self.frameExitRequest.setGeometry(QtCore.QRect(0, 0, 0, 0))
        
    @pyqtSignature("")
    def on_minMax_released(self):
        return MinMax()

    def on_photo_released(self):
        QMessageBox.information(self, "Loading Data", "Please wait while the data is retrieved...")

    @pyqtSignature("int")
    def on_tabStrip_currentChanged(self, index):
        """
        Slot documentation goes here.
        """
        if (index==9):
            self.frameExitRequest.setGeometry(QtCore.QRect(0, 0, 800, 480))
        elif  (index==6):
            ReturnHistPlots(self)
        elif (index==7):
            self.PopulateEXIFData(self.core.curImageLoc)
        else:
            self.core.valCurTab = index
    
    @pyqtSignature("")
    def on_btnOpen_released(self):
        return FileOpenReleased(self)
       
    @pyqtSignature("Image, String")
    def PopulateEXIFData(self,  filename):
        return ImageExifLoad(self)
        
    @pyqtSignature("int")
    def on_tabPhoto_currentChanged(self, index):
        if (index == 2):
            self.btnFullScreenClose.setGeometry(QtCore.QRect(0, 0, 0, 0))
            if self.core.thumbsCount == 0:
                return populatePhotoList(self)
        elif (index ==1):
           self.loadUndoImages()
        else:
            self.btnFullScreenClose.setGeometry(QtCore.QRect(0, 90, 800, 371))
            
    def loadUndoImages(self):
        self.btnUndoCancel.setVisible(False)
        self.btnUndoGo.setVisible(False)
        i = 0
        self.listUndoList.clear()
        for uIm in self.core.undoList_IM:
            icon =QtGui.QIcon(pil2qpixmap(uIm.thumb))
            if (i == 0):
                self.listUndoList.addItem("Original")
            else:
                self.listUndoList.addItem("Step: "+str(i))
                
            self.listUndoList.item(i).setIcon(icon)
            i+=1
            

#++++++++++++++++++++++  END of Class    

    
    
    @pyqtSignature("")
    def on_btnFullScreen_released(self):
        """
        utton handler for fullscreen  open, calls FullScreenToggle
        """
        self.FullScreenToggle(True)
    
    @pyqtSignature("")
    def on_btnFullScreenClose_released(self):
        """
        Button handler for fullscreen  close, calls FullScreenToggle
        """
        self.FullScreenToggle(False)

    @pyqtSignature("")
    def FullScreenToggle(self,  Show,  ForceTab=0):
        """
        Slot documentation goes here.
        """
        if (Show):
            self.tabPhoto.setCurrentIndex(ForceTab)
            self.framePhoto.setGeometry(QtCore.QRect(0, 0, 800, 480))    
            self.photo.repaint()
            #self.photo_Orig.repaint()
        else:
            self.framePhoto.setGeometry(QtCore.QRect(0, 0, 0, 0))
            
        self.tabPhoto.updateGeometry()
        self.tabStrip.repaint()
        self.repaint()
    
    @pyqtSignature("")
    def on_btn_BC_released(self):
        """
        Black and white conversion to Blue-Cyan
        """
        self.core.valBW = "BC"
        Convert_BW(self, self.core.current.thumb,  self.core.valBW,  False)
    
    @pyqtSignature("")
    def on_btn_GC_released(self):
        """
        Black and white conversion to Green-Cyan
        """
        self.core.valBW = "GC"
        Convert_BW(self, self.core.current.thumb,  self.core.valBW,  False)
    
    @pyqtSignature("")
    def on_btn_GY_released(self):
        """
        Black and white conversion to Green-Yellow
        """
        self.core.valBW = "GY"
        Convert_BW(self, self.core.current.thumb,  self.core.valBW,  False)
    
    @pyqtSignature("")
    def on_btn_BM_released(self):
        """
        Black and white conversion to Blue-Magenta
        """
        self.core.valBW = "BM"
        Convert_BW(self, self.core.current.thumb,  self.core.valBW,  False)
        
    @pyqtSignature("")
    def on_btn_RM_released(self):
        """
        Black and white conversion to Red-Magenta
        """
        self.core.valBW = "RM"
        Convert_BW(self, self.core.current.thumb,  self.core.valBW,  False)
    
    @pyqtSignature("")
    def on_btn_RY_released(self):
        """
        Black and white conversion to Red-yellow
        """
        self.core.valBW = "RY"
        Convert_BW(self, self.core.current.thumb,  self.core.valBW,  False)

    @pyqtSignature("")
    def on_btnBug_released(self):
        """
        Submit bug report to bugs.maemo.org
        """ 
        url='https://bugs.maemo.org/enter_bug.cgi?product=AnselA'
        os.system('browser --url=%s' %url)

    @pyqtSignature("")
    def on_btnPListCancel_released(self):
        """
        Slot documentation goes here.
        """
        self.frameCancelPListLoad.setGeometry(QtCore.QRect(0, 0, 0, 0))
        self.core.populatePhotoList = False
    

        
    @pyqtSignature("")
    def on_btnPlistZoom_released(self):
        """
        This button displays the Zoomed Image, click on it will edit the photo.
        """
        LoadCurImageFromPhotoBrowser(self)
        #self.listPhotos.setCurrentRow(8)

    def ToggleThumbWait(self,  Show):
        if Show:
            self.labWaitThumb.setGeometry(-30, -30, 380, 450)

        else:
            self.labWaitThumb.setGeometry(0, 0, 0, 0)
    
    @pyqtSignature("")
    def on_butReturn_released(self):
        """
        Slot documentation goes here.
        """
        self.FullScreenToggle(False)
    
    
    @pyqtSignature("QListWidgetItem*")
    def on_listPhotos_itemDoubleClicked(self, item):
        """
        Slot documentation goes here.
        """
        self.LoadCurImageFromPhotoBrowser()
    
    @pyqtSignature("")
    def on_btnReloadPList_released(self):
        """
        Slot documentation goes here.
        """
        self.frameReloadRequest.setGeometry(QtCore.QRect(0, 0, 791, 441))
    
    @pyqtSignature("")
    def on_btnReloadCancel_released(self):
        """
        Slot documentation goes here.
        """
        self.frameReloadRequest.setGeometry(QtCore.QRect(0, 0, 0, 0))
    
    @pyqtSignature("")
    def on_btnReloadGo_released(self):
        """
        Slot documentation goes here.
        """
        self.btnEditZoomed.setGeometry(QtCore.QRect(0, 0, 0, 0))
        self.frameReloadRequest.setGeometry(QtCore.QRect(0, 0, 0, 0))
        populatePhotoList(self,  True)
    
    @pyqtSignature("")
    def on_btnPhotoBrowser_released(self):
        """
        Slot documentation goes here.
        """
        self.FullScreenToggle(True,  2)
        
        if self.core.thumbsCount == 0:
            self.populatePhotoList(self,  True)
    
  

    @pyqtSignature("QListWidgetItem*")
    def on_listPhotos_itemClicked(self, item):
        """
        Slot documentation goes here.
        """
        #return listPhotosClicked()
        if str(item.text()) == "Load More...":
            self.core.thumbsCount +=100
            self.populatePhotoList()
            self.btnEditZoomed.setGeometry(QtCore.QRect(220, 280, 281, 0))
        else:
            self.listPhotositemLoad(item)
            
    def listPhotositemLoad(self, item):
        self.photoListZoom.setGeometry(item.getIconZoomSize())
        self.btnPlistZoom.setGeometry(self.photoListZoom.geometry())
        self.core.plistIm= self.core.imageDir+str(item.text())+".jpg"
        im = Image.open(self.core.plistIm)
        wTh,  hTh = convertImSize(self.core, im.size[0], im.size[1],  400)

        plistTim=im.resize((hTh,  wTh))
        self.photoListZoom.setPixmap(pil2qpixmap(plistTim))
        self.photoListZoom.repaint()
        
    @pyqtSignature("QListWidgetItem*")
    def on_listUndoList_itemPressed(self, item):
        """
        Slot documentation goes here.
        """
        self.btnUndoCancel.setVisible(True)
        self.btnUndoGo.setVisible(True)
        if (item.text == "Original"):
            self.core.undoSelected = 0
        else:
            self.core.undoSelected = str(item.text().replace("Step: ",""))
        self.btnUndoGo.setText("Revert to "+str(item.text()))


    @pyqtSignature("int, int, int, int")
    def ScaleLabel(self, yH, xW, h, w):
        """
        Send widget x(Width), y(Height) of center point
        and h,w of image passed.
        """
        return QtCore.QRect(xW-int(w/2), yH-int(h/2), w, h)

    
    @pyqtSignature("")
    def on_btnSaveAs_released(self):
        fileLoc=StripFilename(self, self.core.curImageLoc)
        self.btnSaveAsFilename.setText(fileLoc[1]+"_2")
        self.btnSaveAsLocation.setText(fileLoc[0])
        self.frameSaveAs.setGeometry(0, 40, 800, 480)

    @pyqtSignature("")
    def on_btnSaveAsCancel_pressed(self):
        self.frameSaveAs.setGeometry(0, 40, 0, 480)
    
    @pyqtSignature("")
    def on_btnSaveAsGo_pressed(self):
        self.core.current.image.save(self.btnSaveAsFilenameString().replace("JPEG", "jpg"), str(self.btnSaveAsCombo.currentText()))
        self.frameSaveAs.setGeometry(0, 40, 0, 480)
    
    @pyqtSignature("")
    def on_btnApply_released(self):
        """
        Apply based on tab selection
        """
        ApplyGo(self)
    
    @pyqtSignature("")
    def on_btnUndoGo_released(self):
        self.core.UndoImage_Set()
        self.loadUndoImages()
        
        self.ToggleThumbWait(True)
        self.FullScreenToggle(False)
        FileImageRefresh(self)
        
        
    def on_btn_rot_Vert_released(self):
        self.core.flipRight = not self.core.flipRight 
        FlipThumb(self)
        
    def on_btn_rot_Horz_pressed(self):
        self.core.flipBottom = not self.core.flipBottom 
        FlipThumb(self)
        
    def on_btn_rot_90cw_released(self):
        self.core.valRot = 270
        RotateThumb(self,  self.core.valRot)

    def on_btn_rot_90ccw_released(self):
        self.core.valRot = 90
        RotateThumb(self,  self.core.valRot)
        
    def on_btn_rot_180_released(self):
        self.core.valRot = 180
        RotateThumb(self,  self.core.valRot)
    
    def btnSaveAsFilenameString(self):
        return str(self.btnSaveAsLocation.text())+"/"+str(self.btnSaveAsFilename.text())+"."+str(self.btnSaveAsCombo.currentText())
        
    def btnSaveAsfindFileExists(self):
        if os.path.isfile(self.btnSaveAsFilenameString()):
            self.btnSaveAsGo.setVisible(False)
        else:
            self.btnSaveAsGo.setVisible(True)
            
    def on_btnSaveAsCombo_currentIndexChanged(self, index):
        self.btnSaveAsfindFileExists()

    def on_btnSaveAsLocation_textChanged(self, p0):
        self.btnSaveAsfindFileExists()

    def on_btnSaveAsFilename_textChanged(self, p0):
        self.btnSaveAsfindFileExists()
