# -*- coding: utf-8 -*-
#CPE 1704 TKS
"""
Standard Manupilation modules that are not directly UI based.
"""
from PIL import Image
from PIL import ImageDraw
from PIL import ImageEnhance
from filters.toolbox import *
from core import *
from PyQt4 import QtGui as QtGui 
from PyQt4 import QtCore as QtCore
from PyQt4.QtCore import pyqtSignature


@pyqtSignature("")
def ReturnHistPlots(self):
    """
    Slot documentation goes here.
    """
    histo=self.core.current.image.histogram()
    OrignX=37
    OrignY=108

    ScaleMax=(max(histo)/100)  #256)
    print ScaleMax

    plotList =list()
    valX=0

    for valY in histo:
        ProcVal =int(valY/ScaleMax)
        plotList.append(ProcVal)

    plotR = Image.new("RGB", self.core.plotIm.size)
    plotG = Image.new("RGB", self.core.plotIm.size)
    plotB = Image.new("RGB", self.core.plotIm.size)
    
    plotR.paste(self.core.plotIm)# = self.core.poltIm.copy()
    plotG.paste(self.core.plotIm)
    plotB.paste(self.core.plotIm)
    
    drawR = ImageDraw.Draw(plotR)
    drawG = ImageDraw.Draw(plotG)
    drawB = ImageDraw.Draw(plotB)        

    valX=0
    sortCol = list()
    for x in range(255):
        plotX =OrignX + x
        drawR.line([plotX, OrignY, plotX, OrignY-plotList[x]], fill="red")
        drawG.line([plotX, OrignY, plotX, OrignY-plotList[x+256]], fill="green")
        drawB.line([plotX, OrignY, plotX, OrignY-plotList[x+512]], fill="blue")
    del drawR
    del drawG
    del drawB

    #return plotIm
    
    self.graphRed.setPixmap(pil2qpixmap(plotR.convert("RGB")))
    self.graphGreen.setPixmap(pil2qpixmap(plotG.convert("RGB")))
    self.graphBlue.setPixmap(pil2qpixmap(plotB.convert("RGB")))
