
# -*- coding: utf-8 -*-
#CPE 1704 TKS
"""
Standard Manupilation modules that are not directly UI based.
"""
import os

from PIL import Image
from PyQt4 import QtCore as QtCore, QtGui as QtGui

from files import *
from filters.toolbox import *


@pyqtSignature("Bool")
def populatePhotoList(self, ForceRefresh=False):
    """
    Slot documentation goes here.
    """

    if self.core.thumbsCount == 0:
        self.core.thumbsCount =51
        
    self.frameCancelPListLoad.setGeometry(QtCore.QRect(0, 0, 800, 441))
    self.core.populatePhotoList = True
    self.listPhotos.clear()
    
    self.repaint()
    self.tabPhoto.repaint()
    Tsize = (150,  150)
    i=0
    self.labCancel.setText("Loading Photos...")
    self.labCancel.repaint()
    if not os.path.exists (self.core.thumbsDir):
        os.makedirs (self.core.thumbsDir)
    
    files =[]
    for file in os.listdir(self.core.imageDir):
        files.append(file)
        
    for file in reversed(files):
        if self.core.populatePhotoList ==True:

            if ((not os.path.exists(self.core.thumbsDir+file)) or ForceRefresh):
                try:
                    im = Image.open(self.core.imageDir+file)
                    im.thumbnail((Tsize), Image.NEAREST)
                    #os.remove(self.core.thumbsDir+file)
                    im.save(self.core.thumbsDir+file)
                except:
                    continue
            
            try:
                # Get the PListobject with predefined sizes
                photoItem = PlistWidgetItem()
                im=Image.open(self.core.thumbsDir+file,  "r" )
                icon =QtGui.QIcon(self.core.thumbsDir+file)
                photoItem.setIcon(icon)
                photoItem.setText(file.replace(".jpg", ""))
                photoItem.setIconSize(im.size[0], im.size[1])
                
                photoItem.setImageLocation(self.core.imageDir+file)
                h, w = convertImSize(self.core, im.size[0], im.size[1],  400)
                photoItem.setIconZoomSize(self.ScaleLabel(220,  380, w,  h))
                self.listPhotos.addItem(photoItem)
                self.listPhotos.item(i).setIcon(icon)
                
                if i % 5 == 0:
                    self.labCancel.setText("Loading Photos..."+str(i))
                    self.labCancel.repaint()
            except:
                    continue
                    
            i+=1
            if i == self.core.thumbsCount:
                self.listPhotos.addItem("Load More...")
                break
                
    self.listPhotos.repaint()
    self.frameCancelPListLoad.setGeometry(QtCore.QRect(0, 0, 0, 0))


def LoadCurImageFromPhotoBrowser(self):
    self.ToggleThumbWait(True)
    self.FullScreenToggle(False)
    self.repaint()
    FileImageOpen(self,  self.core.plistIm)
    #self.ImageDisplayRefresh(True)
    

class PlistWidgetItem(QtGui.QListWidgetItem):
    iconSize =(0, 0)
    iconZoomSize =(0, 0, 0, 0)
    thumbLocation= ""
    imageLocation =""
    
    def setIconSize(self,  Height=0,  Width=0):
        self.iconSize =(Height,  Width)

    def getIconSize(self):
        return self.iconSize

    def setIconZoomSize(self, value):
        self.iconZoomSize = value
        
    def getIconZoomSize(self):
        return self.iconZoomSize
        
    def getImageLocation(self):
        return self.imageLocation

    def setImageLocation(self, value):
        self.imageLocation = value

    def getThumbLocation(self):
        return self.thumbLocation

    def setThumbLocation(self, value):
        self.thumbLocation = value
    
    
    
    class PhotoView(QtGui.QLabel):
        def __init__(self, parent=None):
            QtGui.QLabel.__init__(self, parent)
            self.setText('Lorem Ipsum')

        def mouseReleaseEvent(self, event):
            print 'Label clicked!'
